/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.cache;

import org.apache.fulcrum.cache.CachedObject;
import org.apache.fulcrum.cache.Refreshable;

public class RefreshableCachedObject
extends CachedObject {
    private long timeToLive = -1L;
    private long lastAccess = System.currentTimeMillis();

    public RefreshableCachedObject(Refreshable o) {
        super(o);
    }

    public RefreshableCachedObject(Refreshable o, long expires) {
        super(o, expires);
    }

    public synchronized void setTTL(long l) {
        this.timeToLive = l;
    }

    public synchronized long getTTL() {
        return this.timeToLive;
    }

    public synchronized void touch() {
        this.lastAccess = System.currentTimeMillis();
    }

    public synchronized boolean isUntouched() {
        if (this.timeToLive < 0L) {
            return false;
        }
        return this.lastAccess + this.timeToLive < System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Refreshable r = (Refreshable)this.getContents();
        RefreshableCachedObject refreshableCachedObject = this;
        synchronized (refreshableCachedObject) {
            r.refresh();
            this.created += this.getExpires();
        }
    }
}

