/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum;

import org.apache.commons.configuration.Configuration;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.Service;
import org.apache.fulcrum.ServiceBroker;
import org.apache.fulcrum.ServiceException;
import org.apache.log4j.Category;

public abstract class BaseService
implements Service {
    protected boolean isInitialized = false;
    protected ServiceBroker serviceBroker;
    protected Configuration configuration;
    protected String name;

    public abstract void init() throws InitializationException;

    public void shutdown() {
        this.setInit(false);
    }

    public boolean getInit() {
        return this.isInitialized();
    }

    public String getStatus() throws ServiceException {
        return this.isInitialized() ? "Initialized" : "Uninitialized";
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    protected void setInit(boolean value) {
        this.isInitialized = value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setServiceBroker(ServiceBroker broker) {
        this.serviceBroker = broker;
    }

    public ServiceBroker getServiceBroker() {
        return this.serviceBroker;
    }

    public Configuration getConfiguration() {
        if (this.name == null) {
            return null;
        }
        if (this.configuration == null) {
            this.configuration = this.getServiceBroker().getConfiguration(this.name);
        }
        return this.configuration;
    }

    public Object getServiceObject(String name) {
        return this.getServiceBroker().getServiceObject(name);
    }

    public String getRealPath(String path) {
        return this.getServiceBroker().getRealPath(path);
    }

    public Category getCategory() {
        return this.getServiceBroker().getCategory();
    }
}

