/*
 * Decompiled with CFR 0.152.
 */
package slidestore.reference.util;

import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCAwareInputStream
extends InputStream {
    private InputStream _underlyingInputStream = null;
    private Statement _relatedJDBCStatement = null;

    public JDBCAwareInputStream(InputStream is, Statement stmt) {
        this._underlyingInputStream = is;
        this._relatedJDBCStatement = stmt;
    }

    public int available() throws IOException {
        return this._underlyingInputStream.available();
    }

    public void close() throws IOException {
        if (this._underlyingInputStream != null) {
            this._underlyingInputStream.close();
            if (this._relatedJDBCStatement != null) {
                try {
                    this._relatedJDBCStatement.close();
                    ResultSet rs = this._relatedJDBCStatement.getResultSet();
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sqle) {
                    throw new IOException(sqle.getMessage());
                }
                this._relatedJDBCStatement = null;
            }
            this._underlyingInputStream = null;
        }
    }

    public synchronized void mark(int readlimit) {
        this._underlyingInputStream.mark(readlimit);
    }

    public boolean markSupported() {
        return this._underlyingInputStream.markSupported();
    }

    public int read() throws IOException {
        return this._underlyingInputStream.read();
    }

    public int read(byte[] b) throws IOException {
        return this._underlyingInputStream.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this._underlyingInputStream.read(b, off, len);
    }

    public synchronized void reset() throws IOException {
        this._underlyingInputStream.reset();
    }

    public long skip(long n) throws IOException {
        return this._underlyingInputStream.skip(n);
    }
}

