/*
 * Decompiled with CFR 0.152.
 */
package slidestore.oracle;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.slide.common.AbstractServiceBase;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.store.ContentStore;
import slidestore.reference.JDBCContentStore;

public class OracleContentStore
extends JDBCContentStore
implements ContentStore {
    protected void storeContent(String revisionUri, String revisionNumber, NodeRevisionDescriptor revisionDescriptor, NodeRevisionContent revisionContent) throws IOException, SQLException {
        PreparedStatement insertStatement = this.connection.prepareStatement("insert into revisioncontent (uri, xnumber, content) values(?,?, ?)");
        insertStatement.setString(1, revisionUri);
        insertStatement.setString(2, revisionNumber);
        byte[] ba = " ".getBytes();
        int len = ba.length;
        ByteArrayInputStream bis = new ByteArrayInputStream(ba);
        insertStatement.setBinaryStream(3, (InputStream)bis, len);
        insertStatement.executeUpdate();
        insertStatement.close();
        bis.close();
        InputStream is = revisionContent.streamContent();
        if (is != null) {
            PreparedStatement selForUpdateStatement = this.connection.prepareStatement("select content from revisioncontent where uri = ? and xnumber= ? for update");
            selForUpdateStatement.setString(1, revisionUri);
            selForUpdateStatement.setString(2, revisionNumber);
            ResultSet rs = selForUpdateStatement.executeQuery();
            int contentLength = -1;
            OutputStream os = null;
            if (rs.next()) {
                try {
                    Blob blob = rs.getBlob(1);
                    Class[] paramsClasses = new Class[]{};
                    Method getBinaryOutputStreamMethod = blob.getClass().getMethod("getBinaryOutputStream", paramsClasses);
                    Object[] params = new Object[]{};
                    os = (OutputStream)getBinaryOutputStreamMethod.invoke((Object)blob, params);
                }
                catch (NoSuchMethodException ex) {
                    this.getLogger().log((Object)"Oracle driver error", ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                    this.getLogger().log((Object)ex.toString(), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                }
                catch (IllegalAccessException ex) {
                    this.getLogger().log((Object)"Oracle driver error", ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                    this.getLogger().log((Object)ex.toString(), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                }
                catch (InvocationTargetException ex) {
                    this.getLogger().log((Object)"Oracle driver error", ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                    this.getLogger().log((Object)ex.toString(), ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                }
            }
            if (os != null) {
                byte[] buf = new byte[2048];
                int num = -1;
                while ((num = is.read(buf)) > 0) {
                    if (contentLength < 0) {
                        contentLength = 0;
                    }
                    os.write(buf, 0, num);
                    contentLength += num;
                }
                os.close();
            }
            rs.close();
            selForUpdateStatement.close();
            revisionDescriptor.setContentLength((long)contentLength);
        }
    }
}

