/*
 * Decompiled with CFR 0.152.
 */
package slidestore.cloudscape;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.slide.common.AbstractServiceBase;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.security.NodePermission;
import slidestore.reference.JDBCDescriptorsStore;

public class CloudscapeDescriptorsStore
extends JDBCDescriptorsStore {
    protected String[] getDatabaseCreateStatements() {
        String[] statements = new String[]{"create table objects(uri varchar(3200) primary key, classname varchar(4000))", "create table children(uri varchar(4000), childuri varchar(4000))", "create table links(link varchar(4000), linkto varchar(4000))", "create table permissions(object varchar(4000), revisionnumber varchar(20),     subject varchar(4000), \"ACTION\" varchar(4000), inheritable int, negative int)", "create table locks(id varchar(4000), object varchar(4000),     subject varchar(4000), type varchar(4000),     expirationdate varchar(15), inheritable int, xexclusive int)", "create table revisions(uri varchar(3200) primary key,     isversioned int, initialrevision varchar(10))", "create table workingrevision(uri varchar(4000),     baserevision varchar(20), xnumber varchar(20))", "create table latestrevisions(uri varchar(4000),     branchname varchar(4000), xnumber varchar(20))", "create table branches(uri varchar(4000), xnumber varchar(20),     childnumber varchar(20))", "create table revision(uri varchar(4000), xnumber varchar(20),     branchname varchar(4000))", "create table label(uri varchar(4000), xnumber varchar(20),     label varchar(4000))", "create table property(uri varchar(4000), xnumber varchar(20),     name varchar(4000), value varchar(4000), namespace varchar(4000),     type varchar(100), protected int)"};
        return statements;
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        PreparedStatement statement = null;
        try {
            try {
                NodeRevisionNumber revisionNumber = permission.getRevisionNumber();
                if (revisionNumber != null) {
                    statement = this.connection.prepareStatement("delete from permissions where object= ? and subject = ? and \"ACTION\" = ?  and revisionnumber = ? ");
                    statement.setString(4, revisionNumber.toString());
                } else {
                    statement = this.connection.prepareStatement("delete from permissions where object = ? and subject = ? and \"ACTION\" = ? and revisionnumber is NULL");
                }
                statement.setString(1, permission.getObjectUri());
                statement.setString(2, permission.getSubjectUri());
                statement.setString(3, permission.getActionUri());
                statement.execute();
            }
            catch (SQLException e) {
                this.getLogger().log((Object)e, ((AbstractServiceBase)this).LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_6 = null;
            this.closeStatement(statement);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeStatement(statement);
            throw throwable;
        }
    }
}

