/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import org.hsql.StringConverter;
import org.hsql.Trace;

class ByteArray {
    private byte[] data;

    byte[] byteValue() {
        return this.data;
    }

    int compareTo(ByteArray byteArray) {
        int n = this.data.length;
        int n2 = byteArray.data.length;
        int n3 = 0;
        while (true) {
            int n4 = 0;
            int n5 = 0;
            if (n3 < n) {
                n4 = this.data[n3] & 0xFF;
            } else if (n3 >= n2) {
                return 0;
            }
            if (n3 < n2) {
                n5 = byteArray.data[n3] & 0xFF;
            }
            if (n4 > n5) {
                return 1;
            }
            if (n5 > n4) {
                return -1;
            }
            ++n3;
        }
    }

    static byte[] serialize(Object object) throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw Trace.error(17, exception.getMessage());
        }
    }

    static String serializeToString(Object object) throws SQLException {
        return ByteArray.createString(ByteArray.serialize(object));
    }

    Object deserialize() throws SQLException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.data);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw Trace.error(17, exception.getMessage());
        }
    }

    static String createString(byte[] byArray) {
        return StringConverter.byteToHex(byArray);
    }

    public String toString() {
        return ByteArray.createString(this.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    ByteArray(String string) {
        this.data = StringConverter.hexToByte(string);
    }
}

