/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermEnum;
import org.apache.lucene.index.SegmentTermPositions;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BitVector;

final class SegmentMergeInfo {
    Term term;
    int base;
    SegmentTermEnum termEnum;
    SegmentReader reader;
    SegmentTermPositions postings;
    int[] docMap = null;

    SegmentMergeInfo(int b, SegmentTermEnum te, SegmentReader r) throws IOException {
        this.base = b;
        this.reader = r;
        this.termEnum = te;
        this.term = te.term();
        this.postings = new SegmentTermPositions(r);
        if (this.reader.deletedDocs != null) {
            BitVector deletedDocs = this.reader.deletedDocs;
            int maxDoc = this.reader.maxDoc();
            this.docMap = new int[maxDoc];
            int j = 0;
            int i = 0;
            while (i < maxDoc) {
                this.docMap[i] = deletedDocs.get(i) ? -1 : j++;
                ++i;
            }
        }
    }

    final boolean next() throws IOException {
        if (this.termEnum.next()) {
            this.term = this.termEnum.term();
            return true;
        }
        this.term = null;
        return false;
    }

    final void close() throws IOException {
        this.termEnum.close();
        this.postings.close();
    }
}

