/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentsReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.Lock;

public abstract class IndexReader {
    Directory directory;
    private Lock writeLock;

    protected IndexReader(Directory directory) {
        this.directory = directory;
    }

    public static IndexReader open(String path) throws IOException {
        return IndexReader.open(FSDirectory.getDirectory(path, false));
    }

    public static IndexReader open(File path) throws IOException {
        return IndexReader.open(FSDirectory.getDirectory(path, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexReader open(final Directory directory) throws IOException {
        Directory directory2 = directory;
        synchronized (directory2) {
            return (IndexReader)new Lock.With(directory.makeLock("commit.lock")){

                public Object doBody() throws IOException {
                    SegmentInfos infos = new SegmentInfos();
                    infos.read(directory);
                    if (infos.size() == 1) {
                        return new SegmentReader(infos.info(0), true);
                    }
                    SegmentReader[] readers = new SegmentReader[infos.size()];
                    int i = 0;
                    while (i < infos.size()) {
                        readers[i] = new SegmentReader(infos.info(i), i == infos.size() - 1);
                        ++i;
                    }
                    return new SegmentsReader(directory, readers);
                }
            }.run();
        }
    }

    public static long lastModified(String directory) throws IOException {
        return IndexReader.lastModified(new File(directory));
    }

    public static long lastModified(File directory) throws IOException {
        return FSDirectory.fileModified(directory, "segments");
    }

    public static long lastModified(Directory directory) throws IOException {
        return directory.fileModified("segments");
    }

    public static boolean indexExists(String directory) {
        return new File(directory, "segments").exists();
    }

    public static boolean indexExists(File directory) {
        return new File(directory, "segments").exists();
    }

    public static boolean indexExists(Directory directory) throws IOException {
        return directory.fileExists("segments");
    }

    public abstract int numDocs();

    public abstract int maxDoc();

    public abstract Document document(int var1) throws IOException;

    public abstract boolean isDeleted(int var1);

    public abstract byte[] norms(String var1) throws IOException;

    public abstract TermEnum terms() throws IOException;

    public abstract TermEnum terms(Term var1) throws IOException;

    public abstract int docFreq(Term var1) throws IOException;

    public TermDocs termDocs(Term term) throws IOException {
        TermDocs termDocs = this.termDocs();
        termDocs.seek(term);
        return termDocs;
    }

    public abstract TermDocs termDocs() throws IOException;

    public TermPositions termPositions(Term term) throws IOException {
        TermPositions termPositions = this.termPositions();
        termPositions.seek(term);
        return termPositions;
    }

    public abstract TermPositions termPositions() throws IOException;

    public final synchronized void delete(int docNum) throws IOException {
        if (this.writeLock == null) {
            Lock writeLock = this.directory.makeLock("write.lock");
            if (!writeLock.obtain()) {
                throw new IOException("Index locked for write: " + writeLock);
            }
            this.writeLock = writeLock;
        }
        this.doDelete(docNum);
    }

    abstract void doDelete(int var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int delete(Term term) throws IOException {
        TermDocs docs = this.termDocs(term);
        if (docs == null) {
            return 0;
        }
        int n = 0;
        try {
            while (docs.next()) {
                this.delete(docs.doc());
                ++n;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            docs.close();
            throw throwable;
        }
        docs.close();
        return n;
    }

    public final synchronized void close() throws IOException {
        this.doClose();
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    abstract void doClose() throws IOException;

    protected final void finalize() throws IOException {
        if (this.writeLock != null) {
            this.writeLock.release();
            this.writeLock = null;
        }
    }

    public abstract Collection getFieldNames() throws IOException;

    public static boolean isLocked(Directory directory) throws IOException {
        return directory.fileExists("write.lock");
    }

    public static boolean isLocked(String directory) throws IOException {
        return new File(directory, "write.lock").exists();
    }

    public static void unlock(Directory directory) throws IOException {
        directory.deleteFile("write.lock");
        directory.deleteFile("commit.lock");
    }
}

