/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.TimeZone;

public final class URLUtil {
    private static SimpleDateFormat format = new SimpleDateFormat(" EEEE, dd-MMM-yy kk:mm:ss zz");
    protected static BitSet safeCharacters;
    protected static final char[] hexadecimal;

    public static String URLDecode(String str) {
        return URLUtil.URLDecode(str, null);
    }

    public static String URLDecode(String str, String enc) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        byte[] bytes = new byte[len];
        str.getBytes(0, len, bytes, 0);
        return URLUtil.URLDecode(bytes, enc);
    }

    public static String URLDecode(byte[] bytes) {
        return URLUtil.URLDecode(bytes, null);
    }

    public static String URLDecode(byte[] bytes, String enc) {
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        int ix = 0;
        int ox = 0;
        while (ix < len) {
            int b;
            if ((b = bytes[ix++]) == 43) {
                b = 32;
            } else if (b == 37) {
                b = (byte)((URLUtil.convertHexDigit(bytes[ix++]) << 4) + URLUtil.convertHexDigit(bytes[ix++]));
            }
            bytes[ox++] = b;
        }
        if (enc != null) {
            try {
                return new String(bytes, 0, ox, enc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new String(bytes, 0, ox);
    }

    private static byte convertHexDigit(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        if (b >= 65 && b <= 70) {
            return (byte)(b - 65 + 10);
        }
        return 0;
    }

    public static String URLEncode(String path, String enc) {
        int maxBytesPerChar = 10;
        int caseDiff = 32;
        StringBuffer rewrittenPath = new StringBuffer(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, enc);
        }
        catch (Exception e) {
            e.printStackTrace();
            writer = new OutputStreamWriter(buf);
        }
        int i = 0;
        while (i < path.length()) {
            block8: {
                char c = path.charAt(i);
                if (safeCharacters.get(c)) {
                    rewrittenPath.append(c);
                } else {
                    try {
                        writer.write(c);
                        writer.flush();
                    }
                    catch (IOException e) {
                        buf.reset();
                        break block8;
                    }
                    byte[] ba = buf.toByteArray();
                    int j = 0;
                    while (j < ba.length) {
                        byte toEncode = ba[j];
                        rewrittenPath.append('%');
                        int low = toEncode & 0xF;
                        int high = (toEncode & 0xF0) >> 4;
                        rewrittenPath.append(hexadecimal[high]);
                        rewrittenPath.append(hexadecimal[low]);
                        ++j;
                    }
                    buf.reset();
                }
            }
            ++i;
        }
        return rewrittenPath.toString();
    }

    static {
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        safeCharacters = new BitSet(256);
        int i = 97;
        while (i <= 122) {
            safeCharacters.set(i);
            ++i;
        }
        i = 65;
        while (i <= 90) {
            safeCharacters.set(i);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            safeCharacters.set(i);
            ++i;
        }
        safeCharacters.set(45);
        safeCharacters.set(95);
        safeCharacters.set(46);
        safeCharacters.set(42);
        safeCharacters.set(47);
    }
}

