/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.jdbc2pool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

class CPDSConnectionFactory
implements PoolableObjectFactory,
ConnectionEventListener {
    protected ConnectionPoolDataSource _cpds = null;
    protected String _validationQuery = null;
    protected ObjectPool _pool = null;
    protected String _username = null;
    protected String _password = null;
    private Map validatingMap = new HashMap();

    public CPDSConnectionFactory(ConnectionPoolDataSource cpds, ObjectPool pool, String validationQuery, String username, String password) {
        this._cpds = cpds;
        this._pool = pool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._validationQuery = validationQuery;
        this._username = username;
        this._password = password;
    }

    public void activateObject(Object obj) {
    }

    public void connectionClosed(ConnectionEvent event) {
        block2: {
            PooledConnection pc = (PooledConnection)event.getSource();
            if (this.validatingMap.containsKey(pc)) break block2;
            try {
                this._pool.returnObject((Object)pc);
            }
            catch (Exception exception) {
                this.destroyObject(pc);
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        try {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR");
            pc.removeConnectionEventListener(this);
        }
        catch (Exception exception) {}
        this.destroyObject(pc);
    }

    public void destroyObject(Object obj) {
        if (obj instanceof PooledConnection) {
            try {
                ((PooledConnection)obj).close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (SQLException sQLException) {
            }
        }
    }

    public ObjectPool getPool() {
        return this._pool;
    }

    public synchronized Object makeObject() {
        PooledConnection pc = null;
        try {
            pc = this._username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(this._username, this._password);
            pc.addConnectionEventListener(this);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
        return pc;
    }

    public void passivateObject(Object obj) {
    }

    public synchronized void setCPDS(ConnectionPoolDataSource cpds) {
        this._cpds = cpds;
    }

    public synchronized void setPool(ObjectPool pool) throws SQLException {
        if (this._pool != null && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new SQLException(e.getMessage());
            }
        }
        this._pool = pool;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public boolean validateObject(Object obj) {
        boolean valid;
        block18: {
            block16: {
                block17: {
                    valid = false;
                    if (!(obj instanceof PooledConnection)) break block16;
                    PooledConnection pconn = (PooledConnection)obj;
                    String query = this._validationQuery;
                    if (query == null) break block17;
                    Connection conn = null;
                    Statement stmt = null;
                    ResultSet rset = null;
                    this.validatingMap.put(pconn, null);
                    try {
                        try {
                            conn = pconn.getConnection();
                            stmt = conn.createStatement();
                            rset = stmt.executeQuery(query);
                            valid = rset.next();
                        }
                        catch (Exception exception) {
                            valid = false;
                        }
                        Object var9_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        try {
                            rset.close();
                        }
                        catch (Throwable throwable2) {}
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {}
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable4) {}
                        this.validatingMap.remove(pconn);
                        throw throwable;
                    }
                    try {
                        rset.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {}
                    this.validatingMap.remove(pconn);
                    break block18;
                }
                valid = true;
                break block18;
            }
            valid = false;
        }
        return valid;
    }
}

