/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg;

import java.util.Enumeration;
import java.util.Hashtable;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.odmg.ObjectEnvelope;
import ojb.odmg.TransactionImpl;
import org.odmg.TransactionAbortedException;

public class ObjectEnvelopeTable {
    private TransactionImpl transaction;
    private Hashtable table = new Hashtable();

    public ObjectEnvelopeTable(TransactionImpl myTransaction) {
        this.transaction = myTransaction;
    }

    public void commit() throws TransactionAbortedException {
        PersistenceBroker broker = this.transaction.getBroker();
        try {
            broker.beginTransaction();
            Enumeration enumeration = this.table.elements();
            while (enumeration.hasMoreElements()) {
                ObjectEnvelope mod = (ObjectEnvelope)enumeration.nextElement();
                if (mod.hasChanged()) {
                    this.transaction.lock(mod.getObject(), 2);
                    mod.setModificationState(mod.getModificationState().markDirty());
                }
                mod.getModificationState().commit(mod, broker);
                broker.invalidate(new Identity(mod.getObject()));
            }
            broker.commitTransaction();
        }
        catch (Throwable t) {
            broker.abortTransaction();
            throw new TransactionAbortedException(t.getMessage());
        }
    }

    public void rollback() {
        PersistenceBroker broker = this.transaction.getBroker();
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            ObjectEnvelope mod = (ObjectEnvelope)enumeration.nextElement();
            if (mod.hasChanged()) {
                mod.setModificationState(mod.getModificationState().markDirty());
            }
            mod.getModificationState().rollback(mod, broker);
        }
    }

    public void remove(Object key) {
        String keyString = null;
        keyString = key instanceof Identity ? key.toString() : new Identity(key).toString();
        this.table.remove(keyString);
    }

    public Enumeration elements() {
        return this.table.elements();
    }

    public ObjectEnvelope get(Object key) {
        String keyString = new Identity(key).toString();
        ObjectEnvelope result = (ObjectEnvelope)this.table.get(keyString);
        if (result == null) {
            result = new ObjectEnvelope(key, this.transaction);
            this.table.put(keyString, result);
        }
        return result;
    }

    public void put(Object key, ObjectEnvelope modification) {
        String keyString = new Identity(key).toString();
        this.table.put(keyString, modification);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("### ObjectEnvelopeTable dump:\n");
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            ObjectEnvelope mod = (ObjectEnvelope)enumeration.nextElement();
            buf.append(mod.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public boolean contains(Object key) {
        String keyString = new Identity(key).toString();
        ObjectEnvelope result = (ObjectEnvelope)this.table.get(keyString);
        return result != null;
    }
}

