/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StreamInterceptor;

public class RequestOutputStream
extends OutputStream {
    protected StreamInterceptor interceptor = null;
    protected boolean closed = false;
    protected OutputStream stream = null;
    private boolean useChunking = false;
    private boolean writingChunk = false;
    private byte[] endChunk = "\r\n".getBytes();
    private byte[] crlf = "\r\n".getBytes();
    private byte[] zero = "0".getBytes();
    private byte[] one = "1".getBytes();
    protected HttpMethod method = null;

    public RequestOutputStream(OutputStream stream, HttpMethod method) {
        this.stream = stream;
        this.method = method;
    }

    public void setUseChunking(boolean useChunking) {
        this.useChunking = useChunking;
    }

    public boolean isUseChunking() {
        return this.useChunking;
    }

    public void setInterceptor(StreamInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        int len = s.length();
        int i = 0;
        while (i < len) {
            this.write(s.charAt(i));
            ++i;
        }
    }

    public void println() throws IOException {
        this.print("\r\n");
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    public void write(int b) throws IOException {
        if (this.interceptor != null) {
            this.interceptor.bytesWrite(null, b, 1);
        }
        if (this.useChunking) {
            this.stream.write(this.one, 0, this.one.length);
            this.stream.write(this.crlf, 0, this.crlf.length);
            this.stream.write(b);
            this.stream.write(this.endChunk, 0, this.endChunk.length);
        } else {
            this.stream.write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.interceptor != null) {
            this.interceptor.bytesWrite(b, off, len);
        }
        if (this.useChunking) {
            byte[] chunkHeader = (Integer.toHexString(len) + "\r\n").getBytes();
            this.stream.write(chunkHeader, 0, chunkHeader.length);
            this.stream.write(b, off, len);
            this.stream.write(this.endChunk, 0, this.endChunk.length);
        } else {
            this.stream.write(b, off, len);
        }
    }

    public void close() throws IOException {
        if (this.useChunking) {
            this.stream.write(this.zero, 0, this.zero.length);
            this.stream.write(this.crlf, 0, this.crlf.length);
            this.stream.write(this.endChunk, 0, this.endChunk.length);
        }
        super.close();
    }
}

