/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.GroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class ModelGroupUnmarshaller
extends SaxUnmarshaller {
    private static final int MODEL_GROUP = 1;
    private static final String MAX_OCCURS_WILDCARD = "unbounded";
    private SaxUnmarshaller unmarshaller;
    private int depth = 0;
    private ModelGroup _group = null;
    private Schema _schema = null;
    private boolean foundAnnotation = false;

    public ModelGroupUnmarshaller(Schema schema, AttributeList attributeList, Resolver resolver) {
        this.setResolver(resolver);
        this._schema = schema;
        this._group = new ModelGroup(this._schema);
        String string = null;
        this._group.setName(attributeList.getValue("name"));
        string = attributeList.getValue("maxOccurs");
        if (string != null) {
            if (this._group.getName() != null) {
                throw new IllegalArgumentException("In <group>: " + this._group.getName() + "'maxOccurs' cannot appear in a named <group>");
            }
            if (MAX_OCCURS_WILDCARD.equals(string)) {
                string = "-1";
            }
            int n = SaxUnmarshaller.toInt(string);
            this._group.setMaxOccurs(n);
        }
        if ((string = attributeList.getValue("minOccurs")) != null) {
            if (this._group.getName() != null) {
                throw new IllegalArgumentException("In <group>: " + this._group.getName() + ", 'minOccurs' cannot appear in a named <group>");
            }
            this._group.setMinOccurs(SaxUnmarshaller.toInt(string));
        }
        if ((string = attributeList.getValue("ref")) != null) {
            if (this._group.getName() != null) {
                throw new IllegalArgumentException("In <group>: " + this._group.getName() + ", 'ref' cannot appear in a named <group>");
            }
            this._group.setReference(string);
        }
        string = attributeList.getValue("id");
        this._group.setId(string);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }

    public String elementName() {
        return "group";
    }

    public void endElement(String string) throws SAXException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        if (this.unmarshaller != null && !string.equals(this.unmarshaller.elementName())) {
            String string2 = "missing end element for ";
            string2 = String.valueOf(string2) + this.unmarshaller.elementName();
            throw new SAXException(string2);
        }
        if ("annotation".equals(string)) {
            Annotation annotation = (Annotation)this.unmarshaller.getObject();
            this._group.addAnnotation(annotation);
        } else if (SchemaNames.isGroupName(string)) {
            Group group = ((GroupUnmarshaller)this.unmarshaller).getGroup();
            this._group.addGroup(group);
        }
        this.unmarshaller.finish();
        this.unmarshaller = null;
    }

    public ModelGroup getGroup() {
        return this._group;
    }

    public Object getObject() {
        return this.getGroup();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if ("annotation".equals(string)) {
            if (this.foundAnnotation) {
                this.error("Only one (1) 'annotation' is allowed as a child of element definitions.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else if (SchemaNames.isGroupName(string)) {
            this.unmarshaller = new GroupUnmarshaller(this._schema, string, attributeList, this.getResolver());
        } else {
            StringBuffer stringBuffer = new StringBuffer("illegal element <");
            stringBuffer.append(string);
            stringBuffer.append("> found in <group>.");
            throw new SAXException(stringBuffer.toString());
        }
    }
}

