/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.utils.servlet.session.HttpServletRequestFacade;

public class SessionExampleServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$servlet$SessionExampleServlet == null ? (class$org$apache$jcs$servlet$SessionExampleServlet = SessionExampleServlet.class$("org.apache.jcs.servlet.SessionExampleServlet")) : class$org$apache$jcs$servlet$SessionExampleServlet));
    ResourceBundle rb = ResourceBundle.getBundle("LocalStrings");
    static /* synthetic */ Class class$org$apache$jcs$servlet$SessionExampleServlet;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            request = new HttpServletRequestFacade(request, response);
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println("<html>");
            out.println("<body bgcolor=\"white\">");
            out.println("<head>");
            String title = this.rb.getString("sessions.title");
            out.println("<title>" + title + "</title>");
            out.println("</head>");
            out.println("<body>");
            out.println("<h3>" + title + "</h3>");
            HttpSession session = null;
            try {
                session = request.getSession(true);
            }
            catch (IllegalStateException ise) {
                log.warn((Object)ise.toString());
            }
            out.println(this.rb.getString("sessions.id") + " " + session.getId());
            out.println("<br>");
            out.println(this.rb.getString("sessions.isnew") + " " + session.isNew() + "<br>");
            out.println(this.rb.getString("sessions.created") + " ");
            out.println(new Date(session.getCreationTime()) + "<br>");
            out.println(this.rb.getString("sessions.lastaccessed") + " ");
            out.println(new Date(session.getLastAccessedTime()));
            out.println("<br>");
            out.println(this.rb.getString("sessions.requestedid") + " " + request.getRequestedSessionId() + "<br>");
            out.println(this.rb.getString("sessions.requestedidvalid") + " " + request.isRequestedSessionIdValid() + "<br>");
            String invalidate = request.getParameter("INVALIDATE");
            if (invalidate != null) {
                session.invalidate();
            } else {
                String dataName = request.getParameter("dataname");
                String dataValue = request.getParameter("datavalue");
                if (dataName != null && dataValue != null) {
                    session.setAttribute(dataName, (Object)dataValue);
                }
                out.println("<P>");
                out.println(this.rb.getString("sessions.data") + "<br>");
                Enumeration names = session.getAttributeNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    String value = session.getAttribute(name).toString();
                    out.println(name + " = " + value + "<br>");
                }
            }
            out.println("<P>");
            out.print("<form action=\"");
            out.print(response.encodeURL("SessionExample"));
            out.print("\" ");
            out.println("method=POST>");
            out.println(this.rb.getString("sessions.dataname"));
            out.println("<input type=text size=20 name=dataname>");
            out.println("<br>");
            out.println(this.rb.getString("sessions.datavalue"));
            out.println("<input type=text size=20 name=datavalue>");
            out.println("<br>");
            out.println("<input type=submit>");
            out.println("</form>");
            out.println("<P>GET based form:<br>");
            out.print("<form action=\"");
            out.print(response.encodeURL("SessionExample"));
            out.print("\" ");
            out.println("method=GET>");
            out.println(this.rb.getString("sessions.dataname"));
            out.println("<input type=text size=20 name=dataname>");
            out.println("<br>");
            out.println(this.rb.getString("sessions.datavalue"));
            out.println("<input type=text size=20 name=datavalue>");
            out.println("<br>");
            out.println("<input type=submit>");
            out.println("</form>");
            out.println("<P>");
            out.println("<P>Invalidate session:<br>");
            out.print("<form action=\"");
            out.print(response.encodeURL("SessionExample"));
            out.print("\" ");
            out.println("method=POST>");
            out.println("<input type=\"hidden\" name=INVALIDATE value=TRUE>");
            out.println("<input type=submit value=\"Invalidate session\">");
            out.println("</form>");
            out.println("</body>");
            out.println("</html>");
            out.println("</body>");
            out.println("</html>");
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

