/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.javagroups;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.control.CompositeCache;
import org.javagroups.Channel;
import org.javagroups.Message;
import org.javagroups.blocks.MessageDispatcher;
import org.javagroups.blocks.RequestHandler;

public class JavaGroupsCache
implements AuxiliaryCache,
RequestHandler {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$javagroups$JavaGroupsCache == null ? (class$org$apache$jcs$auxiliary$javagroups$JavaGroupsCache = JavaGroupsCache.class$("org.apache.jcs.auxiliary.javagroups.JavaGroupsCache")) : class$org$apache$jcs$auxiliary$javagroups$JavaGroupsCache));
    private String cacheName;
    private int status;
    private Channel channel;
    private MessageDispatcher dispatcher;
    private CompositeCache cache;
    private int groupRequestMode;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$javagroups$JavaGroupsCache;

    public JavaGroupsCache(CompositeCache cache, Channel channel, boolean isSynchronous) {
        this.cacheName = cache.getCacheName();
        this.channel = channel;
        this.cache = cache;
        this.groupRequestMode = isSynchronous ? 2 : 6;
        this.dispatcher = new MessageDispatcher(channel, null, null, (RequestHandler)this);
        this.status = 1;
        log.info((Object)("Initialized for cache: " + this.cacheName));
    }

    public void send(ICacheElement element, int command) {
        Request request = new Request(element, command);
        try {
            log.info((Object)"Sending message");
            this.dispatcher.castMessage(null, new Message(null, null, (Serializable)request), this.groupRequestMode, 0L);
            log.info((Object)"Sent message");
        }
        catch (Exception e) {
            log.error((Object)"Failed to send JavaGroups message", (Throwable)e);
        }
    }

    public void update(ICacheElement ce) throws IOException {
        this.send(ce, 1);
    }

    public ICacheElement get(Serializable key) throws IOException {
        return null;
    }

    public boolean remove(Serializable key) throws IOException {
        CacheElement ce = new CacheElement(this.cacheName, key, null);
        this.send(ce, 2);
        return false;
    }

    public void removeAll() throws IOException {
        CacheElement ce = new CacheElement(this.cacheName, null, null);
        this.send(ce, 3);
    }

    public void dispose() throws IOException {
        this.dispatcher.stop();
        this.channel.close();
        this.channel.disconnect();
        this.status = 2;
        log.info((Object)("Disposed for cache: " + this.cacheName));
    }

    public int getSize() {
        return 0;
    }

    public int getStatus() {
        return this.status;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Set getGroupKeys(String group) {
        return null;
    }

    public int getCacheType() {
        return 3;
    }

    public Object handle(Message message) {
        log.info((Object)"Handling message");
        try {
            Request request = (Request)message.getObject();
            switch (request.getCommand()) {
                case 1: {
                    this.cache.localUpdate(request.getCacheElement());
                    break;
                }
                case 2: {
                    this.cache.localRemove(request.getCacheElement().getKey());
                    break;
                }
                case 3: {
                    this.cache.localRemoveAll();
                    break;
                }
                default: {
                    log.error((Object)"Recieved unknown command");
                }
            }
            log.info((Object)"Handled message");
            return Boolean.TRUE;
        }
        catch (Exception e) {
            log.error((Object)"Failed to process received JavaGroups message", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Request
    implements Serializable {
        public static final int UPDATE = 1;
        public static final int REMOVE = 2;
        public static final int REMOVE_ALL = 3;
        private ICacheElement cacheElement;
        private int command;

        public Request(ICacheElement cacheElement, int command) {
            this.cacheElement = cacheElement;
            this.command = command;
        }

        public ICacheElement getCacheElement() {
            return this.cacheElement;
        }

        public int getCommand() {
            return this.command;
        }
    }
}

