/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.webservices.finance.stockmarket;

/**
    BaseStockQuote implements StockQuote, 
    holding the information for one company's quote.
        
    @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
    @version $Id: BaseStockQuote.java,v 1.1 2001/09/23 08:08:05 taylor Exp $
*/

public class BaseStockQuote implements StockQuote
{
    String price = "";
    String name = "";
    String symbol = "";
    String time = "";
    String date = "";
    String high = "";
    String volume = "";
    String change = "";
    String opening = "";
    String low = "";

    public void setPrice(String v) 
    {
        price = v;
    }

    public String getPrice() 
    {
        return price;
    }

    public void setName(String v) 
    {
        name = v;
    }

    public String getName() 
    {
        return name;
    }

    public void setSymbol(String v) 
    {
        symbol = v;
    }

    public String getSymbol() 
    {
        return symbol;
    }

    public void setTime(String v)
    {
        time = v;
    }

    public String getTime() 
    {
        return time;
    }

    public void setDate(String v) 
    {
        date = v;
    }

    public String getDate() 
    {
        return date;
    }

    public void setHigh(String v) 
    {
        high = v;
    }

    public String getHigh() // subliminal
    {
        return high;
    }

    public void setVolume(String v) 
    {
        volume = v;
    }

    public String getVolume() 
    {
        return volume;
    }

    public void setChange(String v) 
    {
        change = v;
    }

    public String getChange() 
    {
        return change;
    }

    public void setOpening(String v) 
    {
        opening = v;
    }

    public String getOpening() 
    {
        return opening;
    }

    public void setLow(String v) 
    {
        low = v;
    }

    public String getLow() 
    {
        return low;
    }

    public String toString() 
    {
        return toXML();
    }

    public String toXML() 
    {
        StringBuffer buffer = new StringBuffer();
        buffer.append("        <Price>");
        buffer.append(price);
        buffer.append("</Price>\n");
        buffer.append("        <Name>");
        buffer.append(name);
        buffer.append("</Name>\n");
        buffer.append("        <Symbol>");
        buffer.append(symbol);
        buffer.append("</Symbol>\n");
        buffer.append("        <Time>");
        buffer.append(time);
        buffer.append("</Time>\n");
        buffer.append("        <Date>");
        buffer.append(date);
        buffer.append("</Date>\n");
        buffer.append("        <High>");
        buffer.append(high);
        buffer.append("</High>\n");
        buffer.append("        <Volume>");
        buffer.append(volume);
        buffer.append("</Volume>\n");
        buffer.append("        <Change>");
        buffer.append(change);
        buffer.append("</Change>\n");
        buffer.append("        <Low>");
        buffer.append(low);
        buffer.append("</Low>\n");
        return buffer.toString();
    }

}
