/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.util.template;

// Jetspeed
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.services.resources.JetspeedResources;

// Turbine
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.services.factory.FactoryService;
import org.apache.turbine.services.pool.TurbinePool;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;

/**
 * Return a JetspeedLink object.  The object may be
 * returned from a pool or instanciated.  The pool
 * is maintained by Turbine's pool service.
 *
 */
public class JetspeedLinkFactory
{
    /**
     * Name of class for JetspeedLink.  The class is the same one used
     * by the tool <code>jslink</code>, so the class name is retrieved from
     * the tool's configuration.
     */
    private static String JETSPEEDLINK_CLASSNAME = JetspeedResources.getString("tool.request.jslink","org.apache.jetspeed.util.template.BaseJetspeedLink");
    private static FactoryService factoryService = (FactoryService) TurbineServices.
            getInstance().getService(FactoryService.SERVICE_NAME);

    
    /**
     * Get an JetspeedLink object.  The object may be retreived
     * from a pool.  If no object is available in the pool, then one will
     * be instanciated.
     *
     * The JetspeedLink's init() should be called to return a valid link.
     *
     * @throws TurbineException by Turbine's pool service
     * @return JetspeedLink
     */
    static JetspeedLink getInstance()
    throws TurbineException
    {
        JetspeedLink jsLink = (JetspeedLink) TurbinePool.getInstance( JETSPEEDLINK_CLASSNAME);
        if (jsLink == null)
            jsLink = (JetspeedLink) factoryService.getInstance(JETSPEEDLINK_CLASSNAME);
        return jsLink;
    }
    
    /**
     * Get an initialized JetspeedLink object.  The object may be retreived
     * from a pool.  If no object is available in the pool, then one will
     * be instanciated.  The object will be initialized with Rundata.
     *
     * @param rundata The request data.
     * @throws TurbineException by Turbine's pool service
     * @return JetspeedLink
     */
    public static JetspeedLink getInstance( RunData rundata)
    throws TurbineException
    {
        JetspeedLink jsLink = getInstance();
        if (jsLink != null)
            jsLink.init(rundata);
        return jsLink;
    }
    
    /**
     * Return an object to the pool
     *
     * @param jetspeedLink object to return to pool
     */
    public static void putInstance(JetspeedLink jetspeedLink)
    {
        if (jetspeedLink != null)
            TurbinePool.putInstance( jetspeedLink);
        return;
    }
}
