/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.util.servlet;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import org.apache.turbine.util.Log;
import org.apache.ecs.ConcreteElement;

import java.util.*;

import org.xml.sax.*;

import org.apache.jetspeed.util.SimpleTransform;

/**
 * NOTE: The use of Ecs for aggregating portlet content is deprecated!
 *       This utility class will be removed once we don't have the ecs 
 *       dependency any more.
 *
 * EcsStylesheetElement encapsulates XML data, a stylesheet and the parameters for 
 * processing the XML data within the context of ECS markup. 
 * 
 * This is a workaround to allow invoking stylesheets from JetSpeed Portlets without
 * buffering strings with the transformation results. Transformation is invoked when
 * traversal of an ECS tree during writing reaches the EcsStylesheetElement.
 *
 * @author Thomas Schaeck (schaeck@de.ibm.com) 
 */
public class EcsStylesheetElement extends ConcreteElement {

/**
 * Processes the referenced XML content using the referenced XSLT stylesheet and 
 * parameters.
 *
 * @param out The output stream to which the result shall be written.
 */
 public void output(OutputStream out)
 {
    output(new PrintWriter(out));
 }               

/**
 * Processes the referenced XML content using the referenced XSLT stylesheet and 
 * parameters.
 *
 * @param out The print writer to be used for writing the result.
 */
public void output(PrintWriter out)
{
    try {
        
        StringReader rdr = new StringReader (SimpleTransform.transform( content_, stylesheet_, params_ ) );
        int count = 0;
        char buff[] = new char[1024];
        while( (count = rdr.read( buff, 0, buff.length ) ) > 0 ) {
            out.write( buff, 0, count );
            }
        
    /*    // Get a new XSLT Processor 
        XSLTProcessor processor = XSLTProcessorFactory.getProcessor();

        // set the parameters for the stylesheet
        if (params_ != null) 
        {
            Enumeration keys = params_.keys();
            while (keys.hasMoreElements()) 
            {
                String name = (String) keys.nextElement();
                processor.setStylesheetParam(name, (String) params_.get(name));
            }
        }

        //  process the stylesheet
        processor.process( content_, stylesheet_, new XSLTResultTarget(out) ); */

	} catch (Exception e) 
        {
            String message = "ECSStylesheetElement.output(PrintWriter): error processing stylesheet" + e.getMessage(); 
            Log.error(message, e);
            out.print(message);
            e.printStackTrace(out);
        }
}   


/** XML content to be processed. */
private InputSource content_;

/** Parameters to be used by the stylesheet. */
private Map params_;

/** XSLT stylesheet to be used for rendering the content. */
private InputSource stylesheet_;

/**
 * Construct an ECS element that will render a given XML dicument using a given 
 * stylesheet and parameters when one of its output methods is invoked.
 *
 * @param content    XML content to be processed
 * @param stylesheet XSLT stylesheet to be used for processing the content
 * @param params	 parameters for the stylesheet
 */
public EcsStylesheetElement( InputSource content, 
                             InputSource stylesheet,
                             Map params ) 
{
    content_ = content;
    stylesheet_ = stylesheet;
    params_ = params;

}

}
