/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.util;


// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.framework.TestCase;


/**
 * Command Line Test Validation routines.
 *
 * @author <a href="mailto:ben.woodward@bbc.co.uk">Ben Woodward</a>
 * @version $Id: TestValidation.java,v 1.3 2003/03/31 00:30:32 taylor Exp $
 */

public class TestValidation extends TestCase
{
    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestValidation( String name ) {
        super( name );
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[]) {
        junit.awtui.TestRunner.main( new String[] { TestValidation.class.getName() } );
    }

    public void setup() {
        System.out.println("Setup: Testing Validation");
     }

    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestValidation.class );
    }


      ///////////////////////////////////////////////////////////////////////////

    public void testAlphaNumeric() throws Exception
    {
        String goodString = "The quick brown fox jumped over the lazy dog 0123456789";
        String badString = "><$$!&.*";

        assertTrue(ValidationHelper.isAlphaNumeric(goodString, false));        
        assertTrue(!ValidationHelper.isAlphaNumeric(badString, false));        
    }
    
    public void testLooseAlphaNumeric() throws Exception
    {
        //String goodString = "The quick brown fox jumped over the lazy dog 0123456789 .";
        //String goodString = "www.www.www-/()+";
        //String badString = "><$$!&*.";
        
        String goodString[] = {"a","a.a","aaa.aaa","a-a","aaa-aaa", "(aaa) aaa", "+aa-aaa.aa", "555-4545", "555,4545"};
        String badString[] = {"><$$!&*."};   
        
        
        for (int ia=0; ia < goodString.length; ia++)
        {
            assertTrue(ValidationHelper.isLooseAlphaNumeric(goodString[ia], false));
            System.out.println(goodString[ia]+" is Good: "+ValidationHelper.isLooseAlphaNumeric(goodString[ia], false));
        }
        
        for (int ib=0; ib < badString.length; ib++)
        {
            assertTrue(!ValidationHelper.isLooseAlphaNumeric(badString[ib], false));
            System.out.println(badString[ib]+" is Bad: "+!ValidationHelper.isLooseAlphaNumeric(badString[ib], false));
        }      
    }
    
    public void testDecimal() throws Exception
    {
        
        String goodString[] = {"1","1.1","11.1","1.11","11.11"};
        String badString[] = {"a","1.a","1-a","1..1","1.1.1"};      
        
        for (int ia=0; ia < goodString.length; ia++)
        {
            assertTrue(ValidationHelper.isDecimal(goodString[ia], false));
        }

        for (int ib=0; ib < badString.length; ib++)
        {
            assertTrue(!ValidationHelper.isDecimal(badString[ib], false));
        }
    }
    
    public void testInteger() throws Exception
    {
        
        String goodString[] = {"1","11","111"};
        String badString[] = {"a","1.1","1.a","1-a","1..1","1.1.1"};      

        for (int ia=0; ia < goodString.length; ia++)
        {
            assertTrue(ValidationHelper.isInteger(goodString[ia], false));
        }

        for (int ib=0; ib < badString.length; ib++)
        {
            assertTrue(!ValidationHelper.isInteger(badString[ib], false));
        }
    }
    
    
    public void testEmailAddress() throws Exception
    {

        String goodString[] = {"a@b.c","a.b@c.d","aa@b.c","aaa@b.c"};
        String badString[] = {"*@b.c","a","a@","@a",".@a","a@b.","a@b","a@@b.c","a@b@c.d","aaa@b^.c"};      

        for (int ia=0; ia < goodString.length; ia++)
        {
            assertTrue(ValidationHelper.isEmailAddress(goodString[ia], false));
        }

        for (int ib=0; ib < badString.length; ib++)
        {
            assertTrue(!ValidationHelper.isEmailAddress(badString[ib], false));
        }
    }
    
    public void testURL() throws Exception
    {
        String goodString = "http://www.apache.org";
        String badString = "me.";
        
        assertTrue(ValidationHelper.isURL(goodString, false));        
        assertTrue(!ValidationHelper.isURL(badString, false));        
    }


    /*
    Configuration object to run Turbine outside a servlet container
    ( uses turbine.properties )
    private static TurbineConfig config = null;
    
    static
    {
    try
    {
    config = new TurbineConfig( "./bin", "/WEB-INF/conf/TurbineResources.properties");
    config.init();
    }
    catch (Exception e)
    {
    //fail(StringUtils.stackTrace(e));
    System.out.println(StringUtils.stackTrace(e));
    }
    }
     */
}



