/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.util;

import java.util.*;
import java.io.*;

// Junit imports
import junit.awtui.TestRunner;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.framework.TestCase;

import org.apache.turbine.util.StringUtils;
import org.apache.tools.ant.util.FileUtils;

/**
 *
 * @author <a href="epugh@upstate.com">Eric Pugh</a>
 */

public class TestOverwriteProperties extends TestCase
{

    private static String SRC_JETSPEED_RESOURCES = "../test/testdata/conf/SrcJetspeedResources.properties";
    private static String JETSPEED_RESOURCES = "../test/testdata/conf/JetspeedResources.properties";
    private static String MERGE_JETSPEED_RESOURCES = "../test/testdata/conf/MergeJetspeedResources.properties";
    private static String MERGE_REMOVE_JETSPEED_RESOURCES = "../test/testdata/conf/MergeRemoveJetspeedResources.properties";
    private static String MERGE_ADD_JETSPEED_RESOURCES = "../test/testdata/conf/MergeAddJetspeedResources.properties";
    private static String RESULT_MERGE_JETSPEED_RESOURCES = "../test/testdata/conf/ResultMergeJetspeedResources.properties";
    private static String RESULT_MERGE_REMOVE_JETSPEED_RESOURCES = "../test/testdata/conf/ResultMergeRemoveJetspeedResources.properties";
    private static String RESULT_MERGE_ADD_JETSPEED_RESOURCES = "../test/testdata/conf/ResultMergeAddJetspeedResources.properties";

    private static String INCLUDE_ROOT = "../test/testdata/conf/";

    private File SRC_JETSPEED_RESOURCES_FILE = null;
    private File JETSPEED_RESOURCES_FILE = null;
    private File MERGE_JETSPEED_RESOURCES_FILE = null;
    private File MERGE_REMOVE_JETSPEED_RESOURCES_FILE = null;
    private File MERGE_ADD_JETSPEED_RESOURCES_FILE = null;
    private File RESULT_MERGE_JETSPEED_RESOURCES_FILE = null;
    private File RESULT_MERGE_REMOVE_JETSPEED_RESOURCES_FILE = null;
    private File RESULT_MERGE_ADD_JETSPEED_RESOURCES_FILE = null;

    private File INCLUDE_ROOT_DIR = null;

    private FileUtils fileUtils = FileUtils.newFileUtils();

    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestOverwriteProperties( String name )
    {
        super( name );
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[])
    {
        junit.awtui.TestRunner.main( new String[] { TestOverwriteProperties.class.getName()} );
    }

    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestOverwriteProperties.class );
    }

    public void setUp() throws Exception{

        SRC_JETSPEED_RESOURCES_FILE = new File(SRC_JETSPEED_RESOURCES);

        assertTrue("Check SRC_JETSPEED_RESOURCES_FILE exists:" + SRC_JETSPEED_RESOURCES_FILE,SRC_JETSPEED_RESOURCES_FILE.exists());

        JETSPEED_RESOURCES_FILE = new File(JETSPEED_RESOURCES);

        if (JETSPEED_RESOURCES_FILE.exists())
        {
            assertTrue("Check JETSPEED_RESOURCES_FILE exists, then delete it:" + JETSPEED_RESOURCES_FILE,JETSPEED_RESOURCES_FILE.delete());
        }

        fileUtils.copyFile(SRC_JETSPEED_RESOURCES_FILE,JETSPEED_RESOURCES_FILE);

        assertTrue("Check JETSPEED_RESOURCES_FILE exists:" + JETSPEED_RESOURCES_FILE,JETSPEED_RESOURCES_FILE.exists());

        MERGE_JETSPEED_RESOURCES_FILE = new File(MERGE_JETSPEED_RESOURCES);

        assertTrue("Check MERGE_JETSPEED_RESOURCES_FILE exists:" + MERGE_JETSPEED_RESOURCES_FILE,MERGE_JETSPEED_RESOURCES_FILE.exists());

        MERGE_REMOVE_JETSPEED_RESOURCES_FILE = new File(MERGE_REMOVE_JETSPEED_RESOURCES);

        assertTrue("Check MERGE_REMOVE_JETSPEED_RESOURCES_FILE exists:" + MERGE_REMOVE_JETSPEED_RESOURCES_FILE,MERGE_REMOVE_JETSPEED_RESOURCES_FILE.exists());

        MERGE_ADD_JETSPEED_RESOURCES_FILE = new File(MERGE_ADD_JETSPEED_RESOURCES);

        assertTrue("Check MERGE_ADD_JETSPEED_RESOURCES_FILE exists:" + MERGE_ADD_JETSPEED_RESOURCES_FILE,MERGE_ADD_JETSPEED_RESOURCES_FILE.exists());

        RESULT_MERGE_JETSPEED_RESOURCES_FILE = new File(RESULT_MERGE_JETSPEED_RESOURCES);

        assertTrue("Check RESULT_MERGE_JETSPEED_RESOURCES_FILE exists:" + RESULT_MERGE_JETSPEED_RESOURCES_FILE,RESULT_MERGE_JETSPEED_RESOURCES_FILE.exists());

        RESULT_MERGE_REMOVE_JETSPEED_RESOURCES_FILE = new File(RESULT_MERGE_REMOVE_JETSPEED_RESOURCES);

        assertTrue("Check RESULT_MERGE_REMOVE_JETSPEED_RESOURCES_FILE exists:" + RESULT_MERGE_REMOVE_JETSPEED_RESOURCES_FILE,RESULT_MERGE_REMOVE_JETSPEED_RESOURCES_FILE.exists());

        RESULT_MERGE_ADD_JETSPEED_RESOURCES_FILE = new File(RESULT_MERGE_ADD_JETSPEED_RESOURCES);

        assertTrue("Check RESULT_MERGE_ADD_JETSPEED_RESOURCES_FILE exists:" + RESULT_MERGE_ADD_JETSPEED_RESOURCES_FILE,RESULT_MERGE_ADD_JETSPEED_RESOURCES_FILE.exists());

        INCLUDE_ROOT_DIR = new File(INCLUDE_ROOT);

        assertTrue("Check include root dir exists:" + INCLUDE_ROOT_DIR,INCLUDE_ROOT_DIR.exists());

        assertTrue(INCLUDE_ROOT_DIR.isDirectory());

    }

    /**
     * Tests overwriting property
     * @throws Exception
     */
    public void testOverwriteProperty() throws Exception
    {

        try
        {
            String args[] = new String[]{JETSPEED_RESOURCES_FILE.toString(),MERGE_JETSPEED_RESOURCES.toString(),INCLUDE_ROOT.toString()};
            OverwriteProperties.main(args);
            assertTrue("Make sure our merge worked properly.",fileUtils.contentEquals(JETSPEED_RESOURCES_FILE,RESULT_MERGE_JETSPEED_RESOURCES_FILE));
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }
    }



    /**
     * Tests removing properties
     * @throws Exception
     */
    public void testRemoveProperties() throws Exception
    {
        try
        {
            String args[] = new String[]{JETSPEED_RESOURCES_FILE.toString(),MERGE_REMOVE_JETSPEED_RESOURCES.toString(),INCLUDE_ROOT.toString()};
            OverwriteProperties.main(args);
            assertTrue("Make sure our merge worked properly.",fileUtils.contentEquals(JETSPEED_RESOURCES_FILE,RESULT_MERGE_REMOVE_JETSPEED_RESOURCES_FILE));
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }
    }

    /**
     * Tests adding properties
     * @throws Exception
     */
    public void testAddProperties() throws Exception
    {
        try
        {
            String args[] = new String[]{JETSPEED_RESOURCES_FILE.toString(),MERGE_ADD_JETSPEED_RESOURCES.toString(),INCLUDE_ROOT.toString()};
            OverwriteProperties.main(args);
            assertTrue("Make sure our merge worked properly.",fileUtils.contentEquals(JETSPEED_RESOURCES_FILE,RESULT_MERGE_ADD_JETSPEED_RESOURCES_FILE));
        }
        catch (Exception e)
        {
            fail(StringUtils.stackTrace(e));
        }
    }

    public void tearDown()
    {
        if (JETSPEED_RESOURCES_FILE.exists())
        {
            //JETSPEED_RESOURCES_FILE.delete();
        }
    }
}
