/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.util;

// Junit imports
import junit.awtui.TestRunner;
import junit.framework.Test;
import junit.framework.TestSuite;

// Cactus imports
import org.apache.cactus.ServletTestCase;
import org.apache.cactus.WebRequest;
import org.apache.cactus.WebResponse;

// Jetspeed imports
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.services.Profiler;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.test.TurbineTestUtilities;

// Turbine imports
//import org.apache.turbine.om.security.User;
import org.apache.turbine.services.pull.TurbinePull;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.RunDataFactory;

// Velocity
import org.apache.velocity.context.Context;

/**
 *
 * @author <a href="paulsp@apache.org">Paul Spencer</a>
 * @version $Id: TestMimeType.java,v 1.3 2002/11/23 11:46:57 paulsp Exp $
 */

public class TestMimeType extends ServletTestCase
{
    private static final String TEST_ANON_USER_NAME = "";
    private static final String TEST_CONTEXT = null;
    private static final String TEST_DEFAULT_PAGE = "default";
    private static final String TEST_HOST = "localhost";
    private static final String TEST_SERVLET = "/portal";
    private static final String TEST_GROUP = "apache";
    private static final String TEST_PAGE = "news";
    private static final String TEST_USER = "turbine";
    private static final String TEST_USER_PASSWORD = "turbine";
    
    private RunData rundata = null;

    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestMimeType(String name)
    {
        super(name);
    }

    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[])
    {
        TestRunner.main(new String[] { TestMimeType.class.getName() });
    }
    
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite()
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite(TestMimeType.class);
    }
    
    /**
     * Sets up the test case.
     *
     */
    protected void setUp () throws Exception 
    {
    }
    
    /**
     *  Test: DefaultURL
     *  With the default URL "/"
     *    1) A page is generated 
     *    2) The user is anonymous
     *    3) Group and Role are not set
     */
    public void beginDefaultURL(WebRequest theRequest)
    {
        System.out.println("URL = " + theRequest.getURL());
        theRequest.setURL(TEST_HOST, TEST_CONTEXT, TEST_SERVLET, "", null); 
        System.out.println("post set URL = " + theRequest.getURL());
    }

    /**
     * Execute the test
     *
     * @throws Exception
     */
    public void testDefaultURL() throws Exception
    {
        // Create the RunData object to be used during testing.        
        rundata = RunDataFactory.getRunData(request, response, config);
        assertNotNull("Got rundata", rundata);
        TurbineTestUtilities.setupRunData(rundata);

        // Verify we have a CapabilityMap
        CapabilityMap cm = ((JetspeedRunData) rundata).getCapability();
        assertNotNull("Got Capability", cm);

        // Verify we have a profile
        Profile profile = Profiler.getProfile(rundata);
        assertNotNull("Got profile from Profiler", profile);
        System.out.println("DocumentName = " + profile.getDocument().getName()); 

        // Get and populate the context
        Context context = TurbineVelocity.getContext(rundata);
        assertNotNull("Got context", context);
        TurbinePull.populateContext(context, rundata);

        // Verify tool are in the context
        assertNotNull("Got jlink from context", context.get("jlink"));

        // Generatate and output thre page
        TurbineTestUtilities.generatePage(rundata);
        assertEquals("Verifying page's character set",
            rundata.getCharSet(), 
            JetspeedResources.getString(JetspeedResources.CONTENT_ENCODING_KEY, "utf-8"));

        TurbineTestUtilities.outputPage(rundata);

        // Return the used RunData to the factory for recycling.
        RunDataFactory.putRunData(rundata);
    }

    public void endDefaultURL(WebResponse theResponse)
    {
        System.out.println("text length = " + theResponse.getText().length());
    }
}
