/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.test;

// Turbine imports
import org.apache.turbine.modules.actions.sessionvalidator.SessionValidator;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.modules.PageLoader;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;

/**
 * This class is designed to aid in the testing of Jetspeed
 * page generation.  It includes methods that mimic what
 * is done in turbine.
 *
 * As a minimum you test case should look like:
 * <CODE>
 * {
 *  setupRunData(rundata);
 *  generatePage(rundata);
 *  outputPage(rundata);
 * }
 * </CODE>
 *
 * @author <a href="paulsp@apache.org">Paul Spencer</a>
 * @version $Id: TurbineTestUtilities.java,v 1.1 2002/03/30 12:37:37 paulsp Exp $
*/
public abstract class TurbineTestUtilities
{
   /**
     * Do all of the initialization and setup of RunData.  This includes
     * setting up the session, users.
     *
     * Note: This code is modeled after Turbine's org.apache.turbine.Turbine
     *
     * @param rundata Rundata to setup
     * @throws Exception General exceptions
     */    
    public static void setupRunData(RunData rundata) throws Exception
    {
        if (rundata == null)
            throw new NullPointerException("rundata is null");
        
        // Get the instance of the Session Validator.
        SessionValidator sessionValidator = (SessionValidator)ActionLoader
             .getInstance().getInstance(TurbineResources.getString(
                 "action.sessionvalidator"));
        if (sessionValidator == null)
            throw new NullPointerException("Failed to get a SessonValidator");

        // Fill in the screen and action variables.
        rundata.setScreen( rundata.getParameters().getString("screen") );
        rundata.setAction( rundata.getParameters().getString("action") );
        
        // Login or out if requested
        if ( rundata.hasAction()
           && rundata.getAction().equalsIgnoreCase(TurbineResources
              .getString("action.login"))
           || rundata.getAction().equalsIgnoreCase(TurbineResources
              .getString("action.logout")))
        {
            if (rundata.getAction().equalsIgnoreCase(TurbineResources
              .getString("action.login")))
            {
                String[] names = rundata.getSession().getValueNames();
                if (names != null)
                {
                    for (int i=0; i< names.length; i++)
                    {
                        rundata.getSession().removeValue(names[i]);
                    }
                }
            }
            ActionLoader.getInstance().exec( rundata, rundata.getAction() );
            rundata.setAction(null);
        }

        // Do the session validation
        ActionLoader.getInstance().exec(
           rundata,TurbineResources.getString("action.sessionvalidator") );
        
        // Put the access control list (ACL) into rundata.
        ActionLoader.getInstance().exec(
           rundata,TurbineResources.getString("action.accesscontroller"));
        
    }
    
    /**
     * Generate the page/content defined by rundata
     * @param rundata Rundata to setup
     * @throws Exception General exceptions
     */    
    public static void generatePage(RunData rundata) throws Exception
    {
        if (rundata == null)
            throw new NullPointerException("rundata is null");
        
        String defaultPage = TurbineTemplate.getDefaultPageName(rundata);
        PageLoader.getInstance().exec(rundata, defaultPage);
    }

    /**
     * Instuct turbine, via rundata, to output the page.
     *
     * Note: This code is modeled after Turbine's org.apache.turbine.Turbine
     *
     * @param rundata Rundata to setup
     * @throws Exception General exceptions
     */    
    public static void outputPage(RunData rundata) throws Exception
    {
        if (rundata == null)
            throw new NullPointerException("rundata is null");
        
        rundata.getResponse().setLocale( rundata.getLocale() );
        rundata.getResponse().setContentType( rundata.getContentType() );
        rundata.getResponse().setStatus( rundata.getStatusCode() );
        rundata.getPage().output(rundata.getOut());
        
        try
        {
            rundata.getOut().close();
        }
        catch (Exception e)
        {
            // Ignore.
        }
    }

}