/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.webpage;

// javax.servlet
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.ServletException;

// java.io
import java.io.IOException;

// java.util
import java.util.Collection;


/**
 * The WebPage Service service interface definition.
 * All implementations of an WebPage Service must implement this interface.
 *
 * Interface defines methods to control the WebPage service, 
 * to manage 0..n sessions amongst 0..n sites.
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: WebPageService.java,v 1.1 2003/02/12 08:12:28 taylor Exp $
 */

interface WebPageService 
{

    /** The name of this service */
    public final static String SERVICE_NAME      = "WebPageService";

    /**
     * The primary method invoked when the a proxied GET is executed.
     *
     * @param servlet the Servlet.          
     * @param req Servlet request.
     * @param res Servlet response.
     * @exception IOException a servlet exception.
     * @exception ServletException a servlet exception.
     */
    
    public void get(HttpServlet servlet,
                    HttpServletRequest request, 
                    HttpServletResponse response)
        throws ServletException, IOException;


    /**
     * The primary method invoked when the a proxied POST is executed.
     *
     * @param servlet the Servlet.     
     * @param req Servlet request.
     * @param res Servlet response.
     * @exception IOException a servlet exception.
     * @exception ServletException a servlet exception.
     */
    public void post(HttpServlet servlet,
                     HttpServletRequest request, 
                     HttpServletResponse response)
        throws ServletException, IOException;

    /**
     * One time initialization of the WebPage service
     *
     * @param config the servlet configuration.     
     * @exception IOException a servlet exception.
     * @exception ServletException a servlet exception.
     */
    public boolean init(ServletConfig config)
            throws ServletException, IOException;

    /**
     * One time de-initialization of the proxy service
     *
     */
    public void destroy();


    /**
     * Returns true if the service was initialized successfully.
     *
     * @return true if the service was initialized successfully.
     */
    public boolean isInit();

    /**
     * Returns a snapshot of all the active and inactive sessions.
     *
     * @return the collection of sessions.
     */
    public Collection getSessions();

    /**
     * Returns a Session, give a string id key identifying that session.
     *
     * @param id The ID of the session.
     * @return The corresponding sessions.
     */
    public SessionMap getSession(String id);

    /**
     * Returns a snapshot collection of all the sites managed by this Proxy service.
     *
     * @return the collection of managed sites.
     */
    public Collection getSites();


    /**
     * Returns the error string from failed initialized.
     *
     * @return the error string from last error.
     */
    public String getErrorString();
}

