/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.security.nosecurity;

import java.util.Iterator;
import java.util.Vector;

// Jetspeed Security
import org.apache.jetspeed.services.security.RoleManagement;

import org.apache.jetspeed.om.security.Role;

import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.om.security.BaseJetspeedRole;

// Jetspeed Security Exceptions
import org.apache.jetspeed.services.security.JetspeedSecurityException;

// Turbine
import org.apache.turbine.services.TurbineBaseService;

/**
 * <p> The <code>NoRoleManagement</code> class is a Jetspeed
 * security provider, implementing the <code>RoleManagement</code> interface.
 * It provides no role management - only the "user" role exists for any user, no roles are
 * listed or saved, any role requested is supplied with a temp. Role object.
 *
 * @author <a href="mailto:ggolden@apache.org">Glenn R. Golden</a>
 * @version $Id: NoRoleManagement.java,v 1.1 2002/09/06 03:29:40 ggolden Exp $
 */
public class NoRoleManagement
    extends TurbineBaseService
   implements RoleManagement
{
    /**
     * Retrieves all <code>Role</code>s for a given username principal.
     *   
     * The security service may optionally check the current user context
     * to determine if the requestor has permission to perform this action.
     *
     * @param username a user principal identity to be retrieved.
     * @return Iterator over all roles associated to the user principal.
     * @exception RoleException when the security provider has a general failure.
     * @exception InsufficientPrivilegeException when the requestor is denied due to insufficient privilege 
     */
    public Iterator getRoles(String username)
        throws JetspeedSecurityException
    {
        // give everyone the "user" role
        Vector v = new Vector(1);
        BaseJetspeedRole r = new BaseJetspeedRole();
        //r.setNew(false);
        r.setName(JetspeedSecurity.JETSPEED_ROLE_USER);
        r.setId(JetspeedSecurity.JETSPEED_ROLE_USER);
        v.add(r);
        return v.iterator();
    }

    /**
     * Retrieves all <code>Role</code>s.
     *   
     * The security service may optionally check the current user context
     * to determine if the requestor has permission to perform this action.
     *
     * @return Iterator over all roles.
     * @exception RoleException when the security provider has a general failure.
     * @exception InsufficientPrivilegeException when the requestor is denied due to insufficient privilege 
     */
    public Iterator getRoles()
        throws JetspeedSecurityException
    {
        return new Vector().iterator();
    }

    /**
     * Adds a <code>Role</code> into permanent storage. 
     *
     * The security service may optionally check the current user context
     * to determine if the requestor has permission to perform this action.
     *
     * @exception RoleException when the security provider has a general failure.
     * @exception InsufficientPrivilegeException when the requestor is denied due to insufficient privilege 
     */
    public void addRole(Role role)
        throws JetspeedSecurityException
    {
    }

    /**
     * Saves a <code>Role</code> into permanent storage. 
     *
     * The security service may optionally check the current user context
     * to determine if the requestor has permission to perform this action.
     *
     * @exception RoleException when the security provider has a general failure.
     * @exception InsufficientPrivilegeException when the requestor is denied due to insufficient privilege 
     */
    public void saveRole(Role role)
        throws JetspeedSecurityException
    {
    }

    /**
     * Removes a <code>Role</code> from the permanent store.
     *
     * The security service may optionally check the current user context
     * to determine if the requestor has permission to perform this action.
     *
     * @param rolename the principal identity of the role to be retrieved.
     * @exception RoleException when the security provider has a general failure.
     * @exception InsufficientPrivilegeException when the requestor is denied due to insufficient privilege 
     */
    public void removeRole(String rolename)
        throws JetspeedSecurityException
    {
    }

    /**
     * Grants a role to a user. 
     *
     * The security service may optionally check the current user context
     * to determine if the requestor has permission to perform this action.
     *
     * @exception RoleException when the security provider has a general failure retrieving roles.
     * @exception InsufficientPrivilegeException when the requestor is denied due to insufficient privilege 
     */
    public void grantRole(String username, String rolename)
        throws JetspeedSecurityException
    {
    }

    /**
     * Revokes a role from a user. 
     *
     * The security service may optionally check the current user context
     * to determine if the requestor has permission to perform this action.
     *
     * @exception RoleException when the security provider has a general failure retrieving roles.
     * @exception InsufficientPrivilegeException when the requestor is denied due to insufficient privilege 
     */
    public void revokeRole(String username, String rolename)
        throws JetspeedSecurityException
    {
    }

    /**
     * Checks for the relationship of user has a role. Returns true when the user has the given role.
     *
     * The security service may optionally check the current user context
     * to determine if the requestor has permission to perform this action.
     *
     * @exception RoleException when the security provider has a general failure retrieving roles.
     * @exception InsufficientPrivilegeException when the requestor is denied due to insufficient privilege 
     */
    public boolean hasRole(String username, String rolename)
        throws JetspeedSecurityException
    {
        // give everyone the "user" role
        if (rolename.equals(JetspeedSecurity.JETSPEED_ROLE_USER)) return true;
        
        return false;
    }

    /**
     * Retrieves a single <code>Role</code> for a given rolename principal.
     *   
     * The security service may optionally check the current user context
     * to determine if the requestor has permission to perform this action.
     *
     * @param rolename a role principal identity to be retrieved.
     * @return Role the role record retrieved.
     * @exception RoleException when the security provider has a general failure.
     * @exception InsufficientPrivilegeException when the requestor is denied due to insufficient privilege 
     */
    public Role getRole(String rolename)
        throws JetspeedSecurityException
    {
        BaseJetspeedRole r = new BaseJetspeedRole();
        //r.setNew(false);
        r.setName(rolename);
        r.setId(rolename);
        return r;
    }
}

