/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.rundata;

import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.om.profile.Profile;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.services.rundata.TurbineRunData;
import org.apache.jetspeed.om.security.JetspeedUser;

/**
 * This interface extends the RunData interface with methods
 * specific to the needs of a Jetspeed like portal implementation.
 *
 * <note>Several of these properties may be put in the base RunData
 * interface in future releases of Turbine</note>
 *
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @version $Id: JetspeedRunData.java,v 1.9 2002/10/30 15:52:39 raphael Exp $
 */
public interface JetspeedRunData extends TurbineRunData
{

    public int NORMAL = 0;
    public int CUSTOMIZE = 1;
    public int MAXIMIZE = 2;

    /**
     * Returns the Jetspeed User (same as getUser without cast)
     *
     * @return the current user.
     */
    public JetspeedUser getJetspeedUser();

    /**
     * Returns the portlet id referenced in this request
     *
     * @return the portlet id referenced or null
     */
    public String getPortlet();

    /**
     * Returns the portlet id (PEID) referenced in this request
     *
     * @return the portlet id (PEID) referenced or null
     */
    public String getJs_peid();

    /**
     * Sets the portlet id referenced for this request
     *
     * @param id the portlet id referenced in this request
     */
    public void setPortlet(String id);

    /**
     * Sets the portlet id (PEID) referenced for this request
     *
     * @param id the portlet id (PEID) referenced in this request
     */
    public void setJs_peid(String peid);

    /**
     * Returns the portlet id which should be customized for this request
     *
     * @return the portlet id being customized or null
     */
    public Portlet getCustomized();

    /**
     * Sets the portlet id to customize
     *
     * @param id the portlet id to customize or null;
     */
    public void setCustomized(Portlet p);

    /**
    * Get the psml profile being customized.
    * @return the Profile being customized.
    */
    public Profile getCustomizedProfile();

    /**
    * Set the psml profile being customized.
    * @param profile The Profile being customized.
    */
    public void setCustomizedProfile(Profile profile);

    /**
    * Clean up from customization
    */
    public void cleanupFromCustomization();

    /**
     * Returns the portlet id which should be maximized for this request
     *
     * @return the portlet id being maximized or null
     */
    public int getMode();

    /**
     * Sets the portlet id to maximize
     *
     * @param id the portlet id to maximize or null;
     */
    public void setMode(int mode);

    /**
     * Sets the portlet id to maximize
     *
     * @param id the portlet id to maximize or null;
     */
    public void setMode(String mode);

    /**
     * Returns the template path as requested from the parameters
     */
    public String getRequestedTemplate();

    /**
     * Sets the template path as requested from the parameters
     */
    public void setRequestedTemplate(String id);

    /**
     * Returns the capability map for the user agent issuing this request
     *
     * @return a capability map objet
     */
    public CapabilityMap getCapability();

    /**
     * Gets the user portal profile for the current request
     *
     * @return a profile implementation for the current request
     */
    public Profile getProfile();

    /**
     * Sets the user portal profile for the current request
     *
     * @param profile a profile implementation for the current request
     */
    public void setProfile(Profile profile);

    /**
     * Get the user id for the current user.
     * This method is provided as an abstraction to the very implementation
     * specific method of retrieving user ids in Turbine.
     *
     * @return String The current user's id.
     */
    public String getUserId();

    /**
     * Access an identifier for the current request's PageSession.
     * A PageSession is a specific portal page being viewed in a specific
     * user session (and perhaps, but not yet [@todo] in a specific browser window).
     * @return the identifier for the current request's PageSession.
     */
    public String getPageSessionId();

    /**
     * Access the current request's UserSession state object.
     * @return the current request's UserSession state object (may be null).
     */
    public SessionState getUserSessionState();

    /**
     * Access the current request's PageSession state object.
     * @return the current request's PageSession state object (may be null).
     */
    public SessionState getPageSessionState();

    /**
     * Access the current request's PortletSession state object.
     * @param id The Portlet's unique id.
     * @return the current request's PortletSession state object. (may be null).
     */
    public SessionState getPortletSessionState(String id);

}

