/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
 
package org.apache.jetspeed.services.psmlmanager.db;

//Castor defined API
import org.apache.jetspeed.om.profile.Portlets;
 
//turbine stuff
import org.apache.turbine.util.Log;

//castor support
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.Marshaller;

import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.ValidationException;

//standard java stuff
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.IOException;


/**
 * This is a utility class used for database PSML implementation.
 *
 * @author <a href="mailto:adambalk@cisco.com">Atul Dambalkar</a>
 * @version $Id: DBUtils.java,v 1.4 2002/03/25 07:33:32 taylor Exp $
 */
public class DBUtils 
{

    /** Deserialize a PSML structure read from bytes array using Castor
     *  XML unmarshaller
     *
     * @param portletBytes Bytes array to load the PSML from
     * @return PSML structure Portlets object
     */
    public static Portlets bytesToPortlets(byte[] portletBytes, Mapping mapping) 
    {
        Reader reader = new StringReader(new String(portletBytes));
        try 
        {
            Unmarshaller unmarshaller = new Unmarshaller((Mapping)mapping);
            return (Portlets)unmarshaller.unmarshal(reader);

//            return Portlets.unmarshal(reader);
        }
        catch (MarshalException e)
        {
            Log.error("PSMLManager: Could not unmarshal the inputstream ", e);
        }  
        catch (MappingException e)
        {
            Log.error("PSMLManager: Could not unmarshal the inputstream ", e);
        }  

        catch (ValidationException e)
        {
            Log.error("PSMLManager: document is not valid", e);
        }
        finally
        {
            try { reader.close(); } 
            catch (IOException e) { Log.error("", e); }
        }
        return null; // control shouldn't arrive here 
    }

    /** Serialize a PSML structure using string writer with Castor XML 
     * marshaller, put it in bytes array and return it.
     *
     * @param portlets the structure to convert to bytes array
     * @return Bytes array object for portles
     */
    public static byte[] portletsToBytes(Portlets portlets, Mapping mapping) 
    {
        if (portlets == null)
        {
            String message = "PSMLManager: Must specify portlets";
            Log.error( message );
            throw new IllegalArgumentException( message );
        }

        StringWriter writer = new StringWriter();
        try 
        {
//            portlets.marshal(writer);

            Marshaller marshaller = new Marshaller(writer);
            marshaller.setMapping(mapping);
            marshaller.marshal(portlets);

            Log.debug("Portlets: " + writer.toString());

            /**** Platform's default character encoding will be used ****/
            return writer.toString().getBytes(); 
        }
        catch (MarshalException e)
        {
            Log.error("PSMLManager: Could not marshal the stringwriter ", e);
        }
        catch (IOException e)
        {
            Log.error("PSMLManager: Could not marshal the stringwriter ", e);
        }
        catch (MappingException e)
        {
            Log.error("PSMLManager: Could not marshal the stringwriter ", e);
        }
        catch (ValidationException e)
        {
            Log.error("PSMLManager: document is not valid", e);
        }
        finally
        {
            try { writer.close(); } 
            catch (IOException e) { Log.error("", e); }
        }
        return null; // control shouldn't arrive here 
    }

}
