/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.portletcache;

import org.apache.jetspeed.portal.expire.Expire;
import org.apache.turbine.services.cache.CachedObject;

/**
 * <p>This is an interface for defining Jetspeed objects that may be 
 * cached in the object cache.</p>
 * <p>Each such object must be able to prodive a caching handle
 * that will uniquely identify it within the cache system</p>
 *
 * @author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @version $Id: Cacheable.java,v 1.6 2002/02/05 03:08:05 paulsp Exp $
 */
public interface Cacheable
{
    /**
     * Return true if this Cacheable is allowed to be cached.
     *
     * @return <CODE>TRUE</CODE> if object is cachable<br>
     * <CODE>FALSE</CODE> if object is not cacheable
     */
    public boolean isCacheable();
    
    /**
     * Set this cacheable status.
     *
     * @param cacheable Set the cacheability of the object
     */
    public void setCacheable(boolean cacheable);
    
    /**
     * Used by a Cacheable object to determine when it should expire itself from
     * the cache.
     *
     * @return Expire handle
     */
    public Expire getExpire();

    /**
     * <p>Used by the cache to get a unique reference on what you want to add
     * and then retrieve in the future from the cache</p>
     *
     * <p>Most implementations should just call the CacheHandleManager with
     * the given params within the implementation and just return this.</p>
     *
     * @deprecated cacheable classes should now implement a static getHandle(config) method
     */
    public String getHandle();

    /***
     * <p>Set the handle for this Cacheable.</p>
     *
     * <p>Note that factories should call setHandle() so that getHandle() always
     * returns a value correctly.</p>
     *
     * @deprecated cacheable classes should now implement a static getHandle(config) method
     */
    public void setHandle( String handle );
  
    /**
     * Return the expiration time in milliseconds.
     *
     * @return Expiration time in milliseconds since epoch, or null if the 
     *         expiration was not set
     */
    public Long getExpirationMillis();

    /**
     * Set the expiration time in milliseconds.
     *
     * @param expirationMillis Set expiration in millis
     */
    public void setExpirationMillis( long expirationMillis);

    /**
     * This allows the associated CachedObject to be
     * known.  One use of the <code>co</code> is to set the expiration time
     *
     * @param co Handle to the CachedObject
     */    
     public void setCachedObject(CachedObject co);
}
