package org.apache.jetspeed.services.logging;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Turbine" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Turbine", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

// Turbine classes
import org.apache.turbine.util.RunData;
import org.apache.turbine.services.logging.Logger;
import org.apache.turbine.services.logging.LoggingConfig;

// commons logging classes
import org.apache.commons.logging.Log; 

/**
 * Classes that implement the Logger interface allows loging.
 * There is set of standart printing methods (info, debug ...).
 * This is a wrapper for the commons Log object.
 *
 * @author <a href="mailto:morciuch@apache.org">Mark Orciuch</a>
 * @version $Id: BaseLogger.java,v 1.1 2002/12/23 23:14:49 morciuch Exp $
 */
public class BaseLogger implements Logger
{
    /**
     * Reference to commons logger
     */
    private Log log = null;

    /**
     * Current log level for logger
     */
    private int logLevel;

    /**
     * Name of the logger
     */
    private String name;

    /**
     * Parametrized constructor
     * 
     * @param log
     */
    public BaseLogger(Log log)
    {
        this.log = log;
    }

    /**
     * name of the logger
     * 
     * @return log name
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * Setings the name
     * 
     * @param logName
     */
    public void setName(String logName)
    {
        this.name = logName;
    }

    /**
     * Reference to commons log
     * 
     * @return commons log
     */
    public Log getLog()
    {
        return this.log;
    }

    /**
     * Sets reference to commons log
     * 
     * @param log
     */
    public void setLog(Log log)
    {
        this.log = log;
    }

    /**
     * This method should be implemented by user.
     * It performs action that are need for deterimne whether
     * logger was well configured or has any output
     * 
     * @return true if logger is well configured
     */
    public boolean checkLogger()
    {

        return true;
    }


    /**
     * This method sets parameters for the logger implementation.
     * If the implementation cannot handle some type of destination should ignore
     * that output.
     *
     * @param LoggingConfig configuration object for logging
     */
    public void init(LoggingConfig loggingConfig)
    {
        // Nothing to do. Declared to satisfy the interface.
    }

    /**
     * Close all destinations
     */
    public void shutdown()
    {
        // nothing to do
    }

    /**
     * Sets log level for the logger
     * 
     * @param level
     */
    public void setLogLevel(int level)
    {
        this.logLevel = level;
    }

     /**
      * Checks if DEBUG statements are enabled.
      * 
      * @return true if debug is enabled
      */
     public boolean isDebugEnabled() 
     {

         return this.log.isDebugEnabled();
     }

     /**
      * Checks if INFO statements are enabled.
      * 
      * @return true if into is enabled
      */
     public boolean isInfoEnabled()
     {

         return this.log.isInfoEnabled();
     }

     /**
      * Checks if WARN statements are enabled.
      * 
      * @return true if warn is enabled
      */
     public boolean isWarnEnabled()
     {

         return this.log.isWarnEnabled();
     }


     /**
      * Checks if ERROR statements are enabled.
      * 
      * @return true if error is enabled
      */
     public boolean isErrorEnabled()
     {

         return this.log.isErrorEnabled();
     }

    /**
     * Sets format style for extracting data from RunData
     * 
     * @param format
     */
    public void setFormat(String format)
    {
        // nothing to do
    }

    /**
     * This is a log method with logLevel == DEBUG
     * 
     * @param message
     */
    public void debug(String message)
    {
        this.log.debug(message);
    }

    /**
     * This is a log method with logLevel == DEBUG
     * 
     * @param message
     * @param t
     */
    public void debug(String message, Throwable t)
    {
        this.log.debug(message, t);
    }

    /**
     * This is a log method with logLevel == DEBUG
     * 
     * @param message
     * @param data
     */
    public void debug(String message, RunData data)
    {
        this.log.debug(message);
    }

    /**
     * This is a log method with logLevel == DEBUG
     * 
     * @param message
     * @param data
     * @param t
     */
    public void debug(String message, RunData data, Throwable t)
    {
        this.log.debug(message, t);
    }

    /**
     * This is a log method with logLevel == INFO
     * 
     * @param message
     */
    public void info(String message)
    {
        this.log.info(message);
    }

    /**
     * This is a log method with logLevel == INFO
     * 
     * @param message
     * @param t
     */
    public void info(String message, Throwable t)
    {
        this.log.info(message, t);
    }

    /**
     * This is a log method with logLevel == INFO
     * 
     * @param message
     * @param data
     */
    public void info(String message, RunData data)
    {
        this.log.info(message);
    }

    /**
     * This is a log method with logLevel == INFO
     * 
     * @param message
     * @param data
     * @param t
     */
    public void info(String message, RunData data, Throwable t)
    {
        this.log.info(message, t);
    }

    /**
     * This is a log method with logLevel == WARN
     * 
     * @param message
     */
    public void warn(String message)
    {
        this.log.warn(message);
    }

    /**
     * This is a log method with logLevel == WARN
     * 
     * @param message
     * @param t
     */
    public void warn(String message, Throwable t)
    {
        this.log.warn(message, t);
    }

    /**
     * This is a log method with logLevel == WARN
     * 
     * @param message
     * @param data
     */
    public void warn(String message, RunData data)
    {
        this.log.warn(message);
    }

    /**
     * This is a log method with logLevel == WARN
     * 
     * @param message
     * @param data
     * @param t
     */
    public void warn(String message, RunData data, Throwable t)
    {
        this.log.warn(message, t);
    }

    /**
     * This is a log method with logLevel == ERROR
     * 
     * @param message
     */
    public void error(String message)
    {
        this.log.error(message);
    }

    /**
     * This is a log method with logLevel == ERROR
     * 
     * @param message
     * @param e
     */
    public void error(String message, Throwable e)
    {
        this.log.error(message, e);
    }

    /**
     * This is a log method with logLevel == ERROR
     * 
     * @param e
     */
    public void error(Throwable e)
    {
        this.log.error(e);
    }

    /**
     * This is a log method with logLevel == ERROR
     * 
     * @param message
     * @param data
     */
    public void error(String message, RunData data)
    {
        this.log.error(message);
    }

    /**
     * This is a log method with logLevel == ERROR
     * 
     * @param message
     * @param data
     * @param e
     */
    public void error(String message, RunData data, Throwable e)
    {
        this.log.error(message, e);
    }
}
