/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2003 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.services.forward;

// Turbine
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.services.pull.ApplicationTool;

import org.apache.jetspeed.util.ServiceUtil;
import org.apache.jetspeed.services.rundata.JetspeedRunData;

/**
 * <p>Provides a tool interface to forwards</p>
 *
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: ForwardTool.java,v 1.2 2003/04/14 19:01:45 taylor Exp $
 */
public class ForwardTool implements ApplicationTool
{
    /**
     *<p>Request to which we refer.</p>
     */
    private JetspeedRunData rundata = null;

    ForwardService service = null;

    /**
     *  Forward to a specific forward by name.
     *
     * @param name Forward to this abstract forward name.
     * @return DynamicURI the full link to the referenced page
     */
    public DynamicURI forward(String forwardName)
    {
        if (null == service)
        {
            service = (ForwardService)ServiceUtil.getServiceByName(ForwardService.SERVICE_NAME);
        }
        return service.forward(this.rundata, forwardName);
    }

    /**
     *  For the given portlet and given action, forward to the target
     *  defined in the forward configuration for the portlet + action.
     *
     * @param portlet The name of the portlet for which we are forwarding.
     * @param target A logical target name. Portlets can have 1 or more targets.
     * @return DynamicURI the full link to the referenced page
     */
    public DynamicURI forward(String portlet, String target)
    {
        if (null == service)
        {
            service = (ForwardService)ServiceUtil.getServiceByName(ForwardService.SERVICE_NAME);
        }
        return service.forward(this.rundata, portlet, target);
    }


    /**
     * Methods required by ApplictionTool interface
     *
     */

    /**
     * This will initialise a JetspeedLink object that was
     * constructed with the default constructor (ApplicationTool
     * method).
     *
     * @param data assumed to be a RunData object
     */

    public void init(Object data)
    {
        // Keeping init small and fast
        if (data instanceof JetspeedRunData)
        {
            this.rundata = (JetspeedRunData) data;
        }
        else
        {
            this.rundata = null;
        }
        return;
    }
    /**
     * Refresh method - does nothing
     */
    public void refresh()
    {
        // empty
    }
}