/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
/*
 * VelocityViewProcessor.java
 *
 *
 * Created on January 27, 2003, 8:54 PM
 */
package org.apache.jetspeed.portal.portlets.viewprocessor;

import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.portlets.*;
import org.apache.jetspeed.portal.portlets.GenericMVCContext;
import org.apache.jetspeed.portal.portlets.viewprocessor.*;
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.util.JetspeedClearElement;

import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;


/**
 *
 * @author  tkuebler
 */
public class VelocityViewProcessor
    implements ViewProcessor
  {

    /** Creates a new instance of VelocityViewProcessor */
    public VelocityViewProcessor()
      {
      }

    public void init(Portlet portlet)
              throws PortletException
      {
      }

    /** Process the template passed in the context
     * (context.get("template")).  Invoked by the GenericMVCPortlet
     * after action handling to process the template type
     * in question.
     *
     */
    public Object processView(GenericMVCContext context)
      {

        // generate the content
        JetspeedClearElement element = null;
        String template = (String) context.get("template");
        Log.info("VelocityViewProcessor - processing " + template);

        try
          {

            if (-1 == template.indexOf(".vm"))
              {
                template = template + ".vm";
              }

            Log.info("VelocityViewProcessor - locating template - " + 
                     ((RunData) context.get("data")).toString() + template);

            String templatePath = TemplateLocator.locatePortletTemplate(
                                          (RunData) context.get("data"), 
                                          template);

            // need to add cache support
            Portlet portlet = (Portlet) context.get("portlet");
            RunData rundata = (RunData) context.get("data");
            long cachePeriod = -1;
            AbstractPortlet abstractPortlet = null;
            // STW: Safety net ;)
            if(portlet instanceof AbstractPortlet)
            {
            	abstractPortlet =(AbstractPortlet) portlet;
            	if(abstractPortlet.getExpirationMillis() != null)
            	{
            		cachePeriod = abstractPortlet.getExpirationMillis().longValue();
            	}
            }
           
			if (cachePeriod > 0 && abstractPortlet != null)
			{
				String s = TurbineVelocity.handleRequest(context, templatePath);
				abstractPortlet.setExpirationMillis(
					cachePeriod + System.currentTimeMillis());
				element = new JetspeedClearElement(s);

			}
			else
			{
				TurbineVelocity.handleRequest(
					context, templatePath, rundata.getOut());
			}
            
            
          }
        catch (Exception e)
          {
            element = new JetspeedClearElement(e.toString());
            Log.error("VelocityViewProcessor - had problems handling request - " + e);
            e.printStackTrace();
          }

        TurbineVelocity.requestFinished(context);

        if (element == null)
          {
            element = new JetspeedClearElement("");
          }

        return element;
      }
  }
