/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal.portlets.admin;

//Element Construction Set
import org.apache.ecs.html.*;
import org.apache.ecs.ConcreteElement;

//Jetspeed stuff
import org.apache.jetspeed.portal.portlets.*;
import org.apache.jetspeed.portal.*;

//turbine
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.Log;
import org.apache.turbine.services.servlet.TurbineServlet;

//standard java stuff
import java.util.*;
import javax.servlet.*;

/**

@author <a href="mailto:tkuebler@cisco.com">Todd Kuebler</a>
@version $Id: ServletContextPortlet.java,v 1.2 2003/03/04 00:05:06 sgala Exp $ 

Based on the Java Runtime Portlet.

*/
public class ServletContextPortlet extends AbstractPortlet {

    
    public ConcreteElement getContent( RunData rundata ) {

        Table table = new Table().setWidth("100%");

        try {

            ServletContext context = TurbineServlet.getServletContext();

            table.addElement( new TR() 
                .addElement( new TH( "Key" ) )
                .addElement( new TH( "String Value" ) ) );

            table.addElement( new TR() 
                .addElement( new TD( "Server Info" ) )
                .addElement( new TD( context.getServerInfo() ) ) );

            table.addElement( new TR() 
                .addElement( new TH( "Attribute" ) )
                .addElement( new TH( "String Value" ) ) );

            Enumeration names = context.getAttributeNames();

            while ( names.hasMoreElements() ) {
                String name = (String) names.nextElement();
                table.addElement( new TR()
                    .addElement( new TD( name ) )
                    .addElement( new TD( context.getAttribute( name ).toString() ) ) );
            }

            table.addElement( new TR() 
                .addElement( new TH( "InitParameter" ) )
                .addElement( new TH( "String Value" ) ) );


            Enumeration ipnames = context.getInitParameterNames();
            while ( ipnames.hasMoreElements() ) {
                String ipname = (String) ipnames.nextElement();
                table.addElement( new TR()
                    .addElement( new TD( ipname ) )
                    .addElement( new TD( context.getInitParameter( ipname ).toString() ) ) );
            }

        } catch (Throwable t) {
            Log.error( t );
            table.addElement( new TR() 
                .addElement( new TD( "Error" ) )
                .addElement( new TD( "Could not read servlet context" ) ) );
        }

        return table;
    }
    
    /**
    @author <a href="mailto:tkuebler@cisco.com">Todd Kuebler</a>
    @version $Id: ServletContextPortlet.java,v 1.2 2003/03/04 00:05:06 sgala Exp $ 
    */
    public void init() throws PortletException {

        this.setTitle("Java Servlet Context");
        this.setDescription("Attributes of your Servlet Context");

    }

    public boolean getAllowEdit(RunData rundata) {
        return false;
    }

    public boolean getAllowMaximize(RunData rundata) {
        return false;
    }
    
    
}
