/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.portal.portlets.admin;

//ecs stuff
import org.apache.ecs.*;
import org.apache.ecs.html.*;

//turbine stuff
import org.apache.turbine.util.*;


//jetspeed stuff
import org.apache.jetspeed.portal.portlets.*;
import org.apache.jetspeed.services.urlmanager.*;

import java.util.*; 

/**
Shows the user what URLs are considered bad.

@author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
@author <a href="mailto:sgala@hisitech.com">Santiago Gala</a>
@version $Id: BadURLManagerPortlet.java,v 1.11 2003/03/04 00:05:06 sgala Exp $ 
*/
public class BadURLManagerPortlet extends AbstractPortlet {

    public static final String RETRY_URL = "retry";


    public ConcreteElement getContent( RunData rundata ) {

        String url = rundata.getParameters().getString( RETRY_URL );

        if ( url != null ) {
            URLManager.unregister(url);
            rundata.getParameters().remove( RETRY_URL );
        }


        
        ElementContainer root = new ElementContainer();

        List urls = URLManager.list( URLManagerService.STATUS_BAD );
        
        root.addElement( "The following " + 
                         urls.size() + 
                         " URL(s) are considered bad: " );

        root.addElement( new BR() );
        
        root.addElement( "Click on a url to take it out of the list" + 
                         " and retry it in when requested. " );

        root.addElement( new BR() );
        
        UL ul = new UL();
        //FIXME: the getReason() call has to be escaped from HTML markup, CR&LF
        DynamicURI uri = new DynamicURI( rundata );
        
        ParameterParser params = rundata.getParameters();
        uri.addQueryData( params );
        
        Iterator i = urls.iterator();
        
        while ( i.hasNext() ) {
            URLInfo info = URLManager.getInfo( (String)i.next() );
            /* It can happen that url is no longer in list while
               we are processing */
            if( info != null ) {
                uri.removeQueryData( RETRY_URL );
                uri.addQueryData(RETRY_URL, info.getURL());
                ul.addElement( new LI()
                    .addElement( new A(uri.toString() )
                        .addElement( info.getURL() ) )
                    .addElement( new B( info.getMessage() ) ) );
            }
        }
        
        root.addElement( ul );

        java.util.Hashtable rt = URLFetcher.getRealtimeURLs();

        root.addElement( "The following " + 
                         rt.size() + 
                         " URL(s) are being loaded: " );

        root.addElement( new BR() );
        ul = new UL();
        
        java.util.Enumeration en = rt.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            LI li = new LI().addElement( key )
                .addElement( " - by " );
            if (rt.get(key) != null )
                li.addElement( String.valueOf(((Vector)rt.get(key)).size()) )
                    .addElement( " threads." );
            ul.addElement( li );
        }
        
        root.addElement( ul );
        

        
        return root;
    }

    public void init() {
        this.setTitle( "BadURLManager" );
        
        this.setDescription( "Shows the admin what URLs are considered bad." );
    }
    
    public boolean getAllowEdit(RunData rundata) {
        return false;
    }

    public boolean getAllowMaximize(RunData rundata) {
        return false;
    }
    
}
