/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal.portlets;

//Element Construction Set
import org.apache.ecs.html.*;
import org.apache.ecs.ConcreteElement;

//Jetspeed stuff
import org.apache.jetspeed.portal.*;

import org.apache.jetspeed.services.PortletFactory;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.om.registry.PortletEntry;

//turbine
import org.apache.turbine.util.*;

//standard java stuff
import java.util.*;

/**
 * Handles enumerating Portlets that are also applications
 *
 * @author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
 * @author <a href="mailto:sgala@hisitech.com">Santiago Gala</a>
 * @version $Id: ApplicationsPortlet.java,v 1.36 2003/03/04 00:05:04 sgala Exp $
 */
public class ApplicationsPortlet extends AbstractPortlet {

    /* SGP: here we cache Applications */
    private Vector applications = new Vector();

    /**
    */
    public void init() throws PortletException
    {

        PortletConfig config = this.getPortletConfig();

        this.setTitle( "Applications" );
        this.setDescription( "A list of Applications that are installed within Jetspeed" );

        Log.info( "Jetspeed: initializing the ApplicationsPortlet: BEGIN " );

        Enumeration portlets = Registry.get( Registry.PORTLET ).getEntries();

        while ( portlets.hasMoreElements() ) {

            PortletEntry entry = (PortletEntry)portlets.nextElement();

            if ( entry.isApplication() )
            {
                applications.addElement(entry);
            }
        }

        Log.info( "Jetspeed: initializing the ApplicationsPortlet: END " );

    }

    /**
    */
    public ConcreteElement getContent( RunData data ) {

        Table table = new Table();
        Enumeration portlets = applications.elements();

        while ( portlets.hasMoreElements() ) {

            PortletEntry entry = (PortletEntry)portlets.nextElement();
            
            String url = PortletURIManager.getPortletMaxURI( entry, data ).toString();
            Portlet portlet = null;
            try {
                portlet = PortletFactory.getPortlet(entry.getName(), "0");
            } catch (PortletException e) {
                continue;
            }
            A anchor = new A( url ).addElement( portlet.getTitle() );
            table.addElement( new TR().addElement( new TD().addElement( anchor ) ) );
            table.addElement( new TR().addElement( new TD().addElement( portlet.getDescription() ) ) );
        }

        return table;

    }


    public boolean getAllowEdit( RunData rundata ) {
        return false;
    }

    public boolean getAllowMaximize( RunData rundata ) {
        return true;
    }


}
