/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal.controllers;

// Turbine stuff
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.services.pull.TurbinePull;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;

// Jetspeed stuff
import org.apache.jetspeed.services.TemplateLocator;

// Ecs stuff
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;

// Velocity Stuff
import org.apache.velocity.context.Context;

/**
 * A Velocity based portlet controller implementation
 * 
 * @author <a href="mailto:re_carrasco@bco011.sonda.cl">Roberto Carrasco</a>
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 *
 * @version $Id: VelocityPortletController.java,v 1.9 2003/03/04 00:05:03 sgala Exp $
 */
public class VelocityPortletController extends AbstractPortletController
{
    public ConcreteElement getContent( RunData rundata )
    {
        // create a blank context and with all the global application
        // Pull Tools inside
        Context context = TurbineVelocity.getContext();
        
        context.put( "data", rundata );
        context.put( "controller", this );
        context.put( "portlets", this.getPortlets().toArray() );
        context.put( "config", this.getConfig() );
        context.put( "skin", this.getPortlets().getPortletConfig().getPortletSkin() );
        context.put( "template", getConfig().getInitParameter("template") );
        
        // Put the request and session based contexts
        TurbinePull.populateContext(context, rundata);
        
        // allow subclass to insert specific objects in the context
        buildContext(rundata, context);
        
        String actionName = getConfig().getInitParameter("action");
        
        if (actionName != null)
        {
            // store the context so that the action can retrieve it
            rundata.getTemplateInfo().setTemplateContext( "VelocityControllerContext", context );

            // if there is an action with the same name in modules/actions/portlets exec it
            try
            {
                ActionLoader.getInstance().exec( rundata, actionName );
            }
            catch( Exception e)
            {
               Log.error( e );
            }
        }
 
        // either the action selected the template, or use the default template 
        // defined in the registry
        String template = (String)context.get( "template" );
        
        // generate the content
        String s = "";

        try
        {
            if (-1 == template.indexOf(".vm"))
            {
                template = template + ".vm";
            }
            
            String templatePath = TemplateLocator.locateControllerTemplate(rundata, template);
            TurbineVelocity.handleRequest(context, templatePath, rundata.getOut());
        }
        catch( Exception e)
        {
            s= e.toString();
        }
        
        TurbineVelocity.requestFinished(context);

        return new StringElement( s );
    }

    public void buildContext(RunData data, Context context)
    {
        // nothing special
    }
}

