/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal;

import org.apache.turbine.util.RunData;
import org.apache.turbine.util.DynamicURI;

/**
 * This interface must be implemented by all portlet controllers that don't
 * display their entire content at one time. The methods defined in this
 * interface allows the controls object that interact with this controller
 * to build the correct links for referencing the hidden portlets
 *
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 *
 * @version $Id: PanedPortletController.java,v 1.8 2002/03/09 06:29:16 taylor Exp $
 */
public interface PanedPortletController extends PortletController, PortletSetController
{
    /*
     * @return the pane parameter name
     *
     */
    public String getPaneParameter();

    /**
     * Test whether the selected portlet is considered selected for the current
     * request.
     *
     * @param p the Portlet to check
     * @param rundata the RunData for the request
     * @return true if the portlet is selected, false otherwise
     */
    public boolean isSelected( Portlet p, RunData rundata );

    /**
     * Builds a link object to access a given pane.
     *
     * @param p the pane portlet object
     * @param rundata the rundata for this request
     * @return a DynamicURI that can be used to reference the specific 
     * portlet
     */
    public DynamicURI getPortletURI( Portlet p, RunData rundata );

    /**
     * Returns the pane id of the parameter used for pane selection
     *
     *  @param rundata The request data.
     *  @param byParameter Set to true to look by query parameter first.
     *  @return String The pane id for the selected pane.
     */
    public String retrievePaneID(RunData rundata, boolean byParameter);

    /**
     * Saves the pane id to the session to remember selection state of menu or tab.
     *
     *  @param rundata The request data.
     *  @param id  The tab id to save for this controller
     */
    public void savePaneID( RunData rundata, String id );

    /**
     * Sets the name of the pane that should
     * be displayed
     *
     * @deprecated
     *
     * @param name the selection parameter name
     */
    public void savePaneName( RunData data, String name );

    /**
     * Returns the name of the pane selector parameter for this controller
     *
     * @deprecated
     */
    public String getParameterName();

    /**
     * Sets the name of the pane selector parameter for this controller
     * @param name the new parameter name
     *
     * @deprecated
     */
    public void setParameterName(String name);

    /**
     * Returns the name of the pane that should be displayed
     * 
     * @deprecated
     *
     * @param byParameter Set to true to look by query parameter first.
     */
    public String retrievePaneName(RunData rundata);

}
