/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.modules.parameters;

// ECS support
import org.apache.ecs.html.Input;
import org.apache.ecs.html.IMG;
import org.apache.ecs.html.A;
import org.apache.ecs.html.Script;
import org.apache.ecs.ElementContainer;     

// Java classes
import java.util.Map;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.text.MessageFormat;

// Turbine support
import org.apache.turbine.util.RunData;

/**
 *  Presentation method to show a date input field with a popup calendar. Calendar is accessed by clicking the icon
 *  next to input field. For now, the only date format supported is mm/dd/yyyy. If value <code>$today</code> is passed, the date in the input field will default to today's date.
 *  <p>Options:
 *  <UL>
 *  <LI><code>$<name>.style.formName</code> - form name where the control is displayed; default=DefaultCustomizer</LI>
 *  <LI><code>$<name>.style.format</code> - date format to use for return value; default=mm/dd/yyyy.
 * The date format can have three types of separators: hyphen(-), space( ), or slash(/), but must be consistent in their usage. E.g.
 * d/m/yyyy
 * The acceptable tokens are :
 *   <UL>
 *   <LI>d - day</LI>
 *   <LI>dd - day (padded with 0 if less than 10)</LI>
 *   <LI>m - month (in numbers)</LI>
 *   <LI>mm - month (in numbers, padded with 0 if less than 10)</LI>
 *   <LI>mmm - month (in words)</LI>
 *   <li>yyyy - year</LI>
 *   </UL> 
 *  </LI>
 *  </UL>
 *  </p>
 * 
 * @author <a href="morciuch@apache.org">Mark Orciuch</a>
 * @version $Id: PopupCalendar.java,v 1.1 2002/09/09 18:48:40 morciuch Exp $
 */
public class PopupCalendar extends ParameterPresentationStyle
{

    public static final String PARM_FORM_NAME   = "formName";
    public static final String PARM_FORMAT      = "format";

    /**
     * Method returning HTML markup for a date list box
     */
    public String getContent(RunData data, String name, String value, Map parms)
    {

        ElementContainer container = new ElementContainer();

        if ( value.equals("$today") )
        {
            Date dt = new Date(System.currentTimeMillis());
            value = new SimpleDateFormat("M/d/yyyy").format(dt);
        }

        container.addElement(new Script().setLanguage("JavaScript").setSrc("javascript/PopupCalendar.js"));

        container.addElement(new Input(Input.TEXT, name, value));

        IMG img = new IMG("images/cal.gif").setAlt("Click here for popup calendar").setBorder(0);
        A a = new A(this.getJavaScript(name), img);

        container.addElement(a);

        return container.toString();
    }

    /**
     * Returns body of the java script event handler
     */
    private String getJavaScript(String fieldName)
    {

        String formName = (String)this.getParm(this.PARM_FORM_NAME, "DefaultCustomizer");
        String format = (String)this.getParm(this.PARM_FORMAT, "mm/dd/yyyy");

        Object[] args = {
            formName,
            fieldName,
            format
        };

        String template = "javascript: show_calendar(''{0}.{1}'',{0}.{1}.value,''{2}'');";

        return new MessageFormat(template).format(args);

    }

    /**
     *  Test method
     */
    public static void main(String args[])
    {

        PopupCalendar pc = new PopupCalendar();      
        System.out.println(pc.getContent(null, "test", "08/01/2001", null));
        System.out.println(pc.getContent(null, "test", "$today", null));

    }

}
