/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.modules.layouts;

//jetspeed stuff
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.util.MimeType;

// Turbine
import org.apache.turbine.modules.Layout;
import org.apache.turbine.modules.NavigationLoader;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.Log;

// ECS Classes
import org.apache.ecs.*;
import org.apache.ecs.wml.*;
import org.apache.ecs.xml.*;

/**
 * Legacy jetspeed Layout used when handling ECS-only content.
 * You should not use it if you want to use Velocity or JSPs.
 *
 * @deprecated This layout is not used anymore in Jetspeed
 * @author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
 * @author <a href="mailto:raphael@apache.org">Raphal Lute</a>
 * @version $Id: JetspeedLayout.java,v 1.10 2003/03/04 00:04:56 sgala Exp $
 */
public class JetspeedLayout extends Layout
{

    public static final String TOP =
        JetspeedResources.getString( JetspeedResources.NAVIGATIONS_TOP_KEY );

    public static final String BOTTOM =
        JetspeedResources.getString( JetspeedResources.NAVIGATIONS_BOTTOM_KEY );

    /**
        The Doctype of WML
    */
    public static final Doctype WML_DOCTYPE =
        new Doctype( "wml",
                     "PUBLIC",
                     "\"-//WAPFORUM//DTD WML 1.1//EN\"",
                     "\"http://www.wapforum.org/DTD/wml_1.1.xml\"" );


    public void doBuild( RunData data ) throws Exception
    {

        CapabilityMap cm = ((JetspeedRunData)data).getCapability();

        MimeType mt = cm.getPreferredType();
        data.setContentType( mt.getContentType() );
        data.setCharSet( mt.getCharSet() );

        Log.debug( "Layout: Setting type to: " + mt );

        if ( mt.equals( MimeType.WML ) ) {
            // we should output WML code, use raw output
            // don"t use navigations for WML

            ElementContainer ec = new ElementContainer();
            WML wml = new WML();
            ec.addElement( new PI().setVersion( 1.0 ) );
            ec.addElement( WML_DOCTYPE );
            ec.addElement( wml );
            wml.addElement( new Template().addElement( new Do( DoType.ACCEPT, "Back" ).addElement( new Prev() ) ) );

            // Now execute the Screen portion of the page
            ConcreteElement screen = ScreenLoader.getInstance().eval ( data, data.getScreen() );
            if (screen != null)
                wml.addElement( screen );

            // output everything on stdout
            try {
                ec.output( data.getOut() );
            } catch ( java.io.IOException e ) {
                Log.error( e );
            } finally {
                ec = null;
            }

        } else {

            // Execute the Top Navigation portion for this Layout
            ConcreteElement topNav =
                NavigationLoader.getInstance().eval ( data, TOP );
            if ( topNav != null)
                data.getPage().getBody().addElement( topNav );

            // Now execute the Screen portion of the page
            ConcreteElement screen = ScreenLoader.getInstance().eval ( data, data.getScreen() );
            if (screen != null)
                data.getPage().getBody().addElement( screen );

            // The screen should have attempted to set a Title
            // for itself, otherwise, a default title is set
            data.getPage().getTitle()
                .addElement( data.getTitle() );

            // The screen should have attempted to set a Body bgcolor
            // for itself, otherwise, a default body bgcolor is set
            data.getPage().getBody()
                .setBgColor(HtmlColor.white);

            // Execute the Bottom Navigation portion for this Layout
            ConcreteElement bottomNav =
            NavigationLoader.getInstance().eval ( data, BOTTOM );
            if ( bottomNav != null)
                data.getPage().getBody().addElement( bottomNav );
        }
    }

}
