/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.modules.actions;

// Java stuff
import java.io.StringWriter;
import java.util.Properties;
  
// Jetspeed Stuff
import org.apache.jetspeed.services.TemplateLocator;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.om.security.JetspeedUser;

// Turbine Stuff
import org.apache.turbine.modules.Action;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.mail.SimpleEmail;
import org.apache.turbine.util.Log;

// Velocity Stuff
import org.apache.velocity.context.Context;

/**
 *  This action will attempt to send a confirmation email to the user.
 *  This class is used in two places, the first one is for new users.
 *  The second is where a user is updating their information after they 
 *  have already created their account. If they are updating and they change 
 *  their email address, then we want to re-confirm it to prevent people from 
 *  screwing up their email address.
 *
 *@author <a href="mailto:paulsp@apache.org">Paul Spencer</a>
 */
public class SendConfirmationEmail extends Action
{
    public void doPerform( RunData data ) throws Exception
    {
        JetspeedUser user = JetspeedSecurity.getUser(data.getParameters().getString("username", ""));        
        DynamicURI url = new DynamicURI(data)
            .addPathInfo(JetspeedResources.PATH_TEMPLATE_KEY, "ConfirmRegistration")
            .addPathInfo("username", user.getUserName())
            .addPathInfo("secretkey", user.getConfirmed())
            .addPathInfo("password", user.getPassword());
        try
        {
            //build body via template
            StringWriter email_body = new StringWriter();
            Context emailContext = TurbineVelocity.getContext(data);
            SimpleEmail se = new SimpleEmail();
            emailContext.put( "data", data );
            emailContext.put( "user", user );
            emailContext.put("config",new JetspeedResources());
            emailContext.put("urltojetspeed",url);
            emailContext.put("email",se);
            String templateFile = JetspeedResources.getString("newuser.confirm.email.template");
            String templatePath = TemplateLocator.locateEmailTemplate(data, templateFile);
            TurbineVelocity.handleRequest(emailContext, templatePath, email_body);

            se.setMsg( email_body.toString() );

            Properties props = System.getProperties();
            String mailServerMachine = JetspeedResources.getString( "mail.server" );
            props.put ( "mail.host", mailServerMachine );
            props.put("mail.smtp.host", mailServerMachine);

            se.send();

            data.setMessage (Localization.getString("SENDCONFIRMATIONEMAIL_SENT"));
        }
        catch ( Exception e )
        {
            String errorTitle = Localization.getString("SENDCONFIRMATIONEMAIL_ERROR") ;
            String errorMessage = errorTitle + e.toString();

            Log.error( errorMessage );
            data.setMessage ( errorTitle + errorMessage );
        }
    }
}
