/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.modules.actions;

 
// Java Core Classes

import javax.servlet.http.Cookie;

// Turbine Modules
import org.apache.turbine.modules.ActionEvent;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.TurbineConstants;

// Jetspeed Stuff
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.jetspeed.om.security.JetspeedUser;



/**
    This class is responsible for logging a user out of the system.
*/
public class JLogoutUser extends ActionEvent
{

    public void doPerform( RunData data ) throws Exception
    {    
        Log.info("Entering action JLogoutUser");

        // if automatic login is enabled, then remove cookies when user logs out
        if ( JetspeedResources.getBoolean("automatic.logon.enable", false) )
        {
          // remove cookies by re-adding them with zero MaxAge, which deletes them
          Cookie userName = new Cookie("username","");
          Cookie loginCookie = new Cookie("logincookie","");

          String comment = JetspeedResources.getString("automatic.logon.cookie.comment","");
          String domain = JetspeedResources.getString("automatic.logon.cookie.domain");
          String path = JetspeedResources.getString("automatic.logon.cookie.path","/");

          if (domain == null)
          {
            String server = data.getServerName();
            domain = "." + server;
          }

          userName.setMaxAge(0);
          userName.setComment(comment);
          userName.setDomain(domain);
          userName.setPath(path);

          loginCookie.setMaxAge(0);
          loginCookie.setComment(comment);
          loginCookie.setDomain(domain);
          loginCookie.setPath(path);

          data.getResponse().addCookie(userName);
          data.getResponse().addCookie(loginCookie);


          // also need to remove the cookies from the current request - otherwise the session validator will log user in again
          if ( data.getRequest().getCookies() != null)
          {
            data.getCookies().remove("logincookie");
            data.getCookies().remove("username");
          }
        }        

        // use the standard turbine logout facility
        if ( JetspeedResources.getBoolean("automatic.logout.save", false) )
        {
            JetspeedSecurity.saveUser((JetspeedUser)data.getUserFromSession());
        }

        JetspeedSecurity.logout();

        data.setMessage(JetspeedResources.getString(
            TurbineConstants.LOGOUT_MESSAGE));

        JetspeedLink jsLink = null;

        data.setScreen(JetspeedResources.getString(
            TurbineConstants.SCREEN_HOMEPAGE));

        try
        {
            jsLink = JetspeedLinkFactory.getInstance(data);
        } catch (Exception e)
        {
            Log.error(e);
        }
        data.setRedirectURI(jsLink.getHomePage().toString());
        JetspeedLinkFactory.putInstance(jsLink);
        jsLink = null;
    }

}
