/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.modules.actions;

// Jetspeed
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.Profiler;

// Turbine
import org.apache.turbine.modules.Action;
import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.services.localization.Localization;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.Log;
import org.apache.turbine.TurbineConstants;

/**
 * Performs change password action
 * 
 * @author <a href="morciuch@apache.org">Mark Orciuch</a>
 * @version $Id: ChangePassword.java,v 1.4 2003/01/17 21:30:37 morciuch Exp $
 */
public class ChangePassword extends Action
{
    public void doPerform(RunData rundata) throws Exception
    {

        String cancelBtn = rundata.getParameters().getString(Localization.getString("PASSWORDFORM_CANCEL"));
        String username  = rundata.getParameters().getString("username" , "");
        String oldPassword  = JetspeedSecurity.convertPassword(rundata.getParameters().getString("old_password" , ""));
        String password  = JetspeedSecurity.convertPassword(rundata.getParameters().getString("password", ""));
        String password2 = JetspeedSecurity.convertPassword(rundata.getParameters().getString("password_confirm", ""));

        // CANCEL BUTTON
        //
        // check to see if the Cancel button was pressed.
        // if so, return to default portal page
        if (cancelBtn != null && cancelBtn.equalsIgnoreCase(Localization.getString("PASSWORDFORM_CANCEL")))
        {
            return;
        }

        String returnTemplate = JetspeedResources.getString(JetspeedResources.CHANGE_PASSWORD_TEMPLATE, "ChangePassword");

        try 
        {

            JetspeedUser user = JetspeedSecurity.getUser(username);

            if (!password.equals(password2))
            {
                rundata.setMessage(Localization.getString("UPDATEACCOUNT_PWNOTMATCH"));
                rundata.setScreenTemplate(returnTemplate);
                return;
            }

            if (password.equals(oldPassword))
            {
                rundata.setMessage(Localization.getString("PASSWORDFORM_THESAME_MSG"));
                rundata.setScreenTemplate(returnTemplate);
                return;
            }

            // Change the password
            JetspeedSecurity.changePassword(user, oldPassword, password);
            rundata.setMessage(Localization.getString("PASSWORDFORM_DONE"));

            // Login again
            rundata.getParameters().setString("username", username);
            rundata.getParameters().setString("password", password);
            String userRequestsRememberMe = rundata.getParameters().getString("rememberme");
            rundata.getParameters().setString("rememberme", userRequestsRememberMe);
            ActionLoader.getInstance().getInstance(
                JetspeedResources.getString(TurbineConstants.ACTION_LOGIN)
                ).doPerform(rundata);

            // Update the profile in rundata - not sure why this is not happening automatically?
            JetspeedRunData jdata = (JetspeedRunData) rundata;
            jdata.setProfile(Profiler.getProfile(jdata));

        }
        catch (Exception e) 
        {
            Log.error(e);
            rundata.setMessage(e.getMessage() != null ? e.getMessage() : e.toString());
            rundata.setScreenTemplate(returnTemplate);
        }
    }

}
