/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.daemon.impl.util.diskcachedaemon;

//jetspeed stuff
import org.apache.jetspeed.om.registry.PortletEntry;
import org.apache.jetspeed.services.Registry;
import org.apache.jetspeed.services.urlmanager.URLFetcher;

//turbine stuff
import org.apache.turbine.util.*;

//Java stuff
import java.util.*;

/**
<p>
URLRefresher that checks if a URL is updated remotely.  If it is then it will
pull the new URL down and try to reinstantiate all Portlets that depend on this
URL.
</p>

@author <A HREF="mailto:burton@apache.org">Kevin A. Burton</A>
@version $Id: URLRefresher.java,v 1.13 2003/03/04 00:04:52 sgala Exp $
*/
public class URLRefresher implements Runnable {

    private String url = null;
    
    /**
    default constructor
    */
    public URLRefresher( String url ) {
        
        this.url = url;
        
    }
    
    /**
    Used within the ThreadPool... IE Runnable interface.
    */
    public void run() {
        
        try {

            //only update this if the URL on which it is based is newer 
            //than the one on disk.
            if(URLFetcher.refresh(url)) {
                //now make sure that the entry that depends on this HREF
                //is updated in the PortletFactory.
                
                
                //create a Runnable for updating this Portlet in the cache.
                    
                Enumeration enum = Registry.get(Registry.PORTLET).getEntries();
                    
                while( enum.hasMoreElements() ) {
                    PortletEntry entry = (PortletEntry)enum.nextElement();
                    
                    if ( (entry.getURL()!= null) && entry.getURL().equals(url) )
                    {
                        try
                        {
                            PortletRefresher pr = new PortletRefresher( entry );
                        
                            //now put this Instantiator in the ThreadPool so that 
                            //it can execute.
                            //SGP Trying to intersperse CPU intensive tasks with
                            // network intensive tasks
                            pr.run();
                            //ThreadPool.process( pr );
                        }
                        catch (Throwable t)
                        {
                            //FIXME: Put it in the bad URL list
                            Log.info( "DiskCacheDaemon: Error refreshing: " + url ); 
                        }
                    }
                }
            }
        } catch ( Throwable t ) {
            Log.error( t );
        }
        
        
    }
    
}
