package org.apache.jetspeed.modules.actions.portlets;

import org.apache.jetspeed.portal.portlets.AbstractVTLPortlet;

// Turbine stuff
import org.apache.turbine.modules.Action;
import org.apache.turbine.util.RunData;

// Jetspeed stuff
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.factory.PortletFactory;
import org.apache.jetspeed.services.registrymanager.RegistryManager;
import org.apache.jetspeed.om.registry.peer.PortletEntry;


/**
Action to config the VTL Hello World portlet

@author <a href="mailto:re_carrasco@bco011.sonda.cl">Roberto Carrasco</a>
*/
public class HelloConfigPortlet extends Action
{
    public void doPerform( RunData rundata ) throws Exception
    {

        if( rundata.getUser() == null || !rundata.getUser().hasLoggedIn() )
        {
            return;
        }

        String name = rundata.getParameters().getString ( "portletName", null );
        if ( name == null )
        {
            return;
        }

        PortletEntry entry = (PortletEntry)RegistryManager.getEntry(RegistryManager.PORTLET_REGISTRY, name );
        if ( entry == null )
        {
            return;
        }

        Portlet portlet = PortletFactory.getPortlet( entry );
        if ( portlet == null )
        {
            return;
        }

        String saludo = rundata.getParameters().getString ( "saludo", null );
        if ( saludo == null )
        {
            return;
        }

        ( (AbstractVTLPortlet)portlet ).setAttribute( "saludo", saludo, rundata );
    }

}
