package org.apache.jetspeed.modules.actions.portlets;

import org.apache.jetspeed.portal.portlets.AbstractVTLPortlet;

// Turbine stuff
import org.apache.turbine.util.RunData;
import org.apache.turbine.modules.Action;

// Velocity Stuff
import org.apache.velocity.context.Context;


/**
An abstract class to build actions supporting VTLPortlets

Don't put in URL, it's called automatically by VTLPortlet when needed

@author <a href="mailto:re_carrasco@bco011.sonda.cl">Roberto Carrasco</a>
*/
public abstract class AbstractVTLPortletAction extends Action
{
    public void doPerform( RunData rundata )
    {
        Context context = (Context)rundata.getTemplateInfo().getTemplateContext( "VTLPortletContext" );
        AbstractVTLPortlet xPortlet = (AbstractVTLPortlet)context.get( "portlet" );
        boolean loggedUser = rundata.getUser() != null && rundata.getUser().hasLoggedIn();


        // portlet must be configured
        if( xPortlet.isButtonConfigure( rundata ) )
        {
            if( loggedUser )
            {
                setConfigureContent( xPortlet, context, rundata );
            }
            return;
        }

        // portlet must shows maximized
        if( xPortlet.isButtonMaximize( rundata ) )
        {
            setMaximizedContent( xPortlet, context, rundata, loggedUser );
            return;
        }

        // portlet is minimized - let's change at least the title bar
        if( xPortlet.isMinimized( rundata ) )
        {
            if( loggedUser )
            {
                setMinimizedContent( xPortlet, context, rundata );
            }
            return;
        }

        // show in standar way ( with portlets around it )
        setNormalContent( xPortlet, context, rundata, loggedUser );
    }

    // only if conf button clicked
    abstract void setConfigureContent( AbstractVTLPortlet xPortlet, 
                                       Context context, RunData rundata );

    // only if max button clicked
    abstract void setMaximizedContent( AbstractVTLPortlet xPortlet, 
                                       Context context, RunData rundata, boolean loggedUser );

    // only in minimized state
    abstract void setMinimizedContent( AbstractVTLPortlet xPortlet, 
                                       Context context, RunData rundata );

    // only in normal state
    abstract void setNormalContent( AbstractVTLPortlet xPortlet, 
                                    Context context, RunData rundata, boolean loggedUser );

}
