/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.ant;

import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class PathConvert
extends Task {
    private Path path = null;
    private Reference pathref = null;
    private String targetOS = null;
    private boolean targetWindows = false;
    private boolean onWindows = false;
    private String property = null;
    private ArrayList prefixMap = new ArrayList();

    public Path createPath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.path == null) {
            this.path = new Path(this.getProject());
        }
        return this.path.createPath();
    }

    public MapEntry createMap() {
        MapEntry entry = new MapEntry();
        this.prefixMap.add(entry);
        return entry;
    }

    public void setTargetos(String target) {
        this.targetOS = target.toLowerCase();
        if (!this.targetOS.equals("windows") && !target.equals("unix")) {
            throw new BuildException("targetos must be one of 'unix' or 'windows'");
        }
        this.targetWindows = this.targetOS.equals("windows");
    }

    public void setProperty(String p) {
        this.property = p;
    }

    public void setPathRef(Reference r) {
        if (this.path != null) {
            throw this.noChildrenAllowed();
        }
        this.pathref = r;
    }

    public boolean isReference() {
        return this.pathref != null;
    }

    public void execute() throws BuildException {
        if (this.isReference()) {
            this.path = new Path(this.getProject()).createPath();
            this.path.setRefid(this.pathref);
        }
        this.validateSetup();
        String osname = System.getProperty("os.name").toLowerCase();
        this.onWindows = osname.indexOf("windows") >= 0;
        StringBuffer rslt = new StringBuffer(100);
        if (this.onWindows != this.targetWindows) {
            char pathSep = this.targetWindows ? (char)';' : ':';
            String[] elems = this.path.list();
            int i = 0;
            while (i < elems.length) {
                String elem = elems[i];
                elem = this.mapElement(elem);
                elem = this.targetWindows ? elem.replace('/', '\\') : elem.replace('\\', '/');
                if (i != 0) {
                    rslt.append(pathSep);
                }
                rslt.append(elem);
                ++i;
            }
        } else {
            rslt.append(this.path.toString());
        }
        String value = rslt.toString();
        this.log("Set property " + this.property + " = " + value, 3);
        this.getProject().setProperty(this.property, value);
    }

    private String mapElement(String elem) {
        block4: {
            int size;
            block2: {
                block3: {
                    size = this.prefixMap.size();
                    if (size != 0) break block2;
                    if (!this.targetWindows) break block3;
                    elem = "C:" + elem;
                    break block4;
                }
                if (elem.charAt(1) != ':') break block4;
                elem = elem.substring(2);
                break block4;
            }
            int i = 0;
            while (i < size) {
                MapEntry entry = (MapEntry)this.prefixMap.get(i);
                String newElem = entry.apply(elem);
                if (newElem != elem) {
                    elem = newElem;
                    break;
                }
                ++i;
            }
        }
        return elem;
    }

    private void validateSetup() throws BuildException {
        if (this.path == null) {
            throw new BuildException("You must specify a path to convert");
        }
        if (this.targetOS == null) {
            throw new BuildException("You must specify a target OS");
        }
        if (this.property == null) {
            throw new BuildException("You must specify a property");
        }
    }

    private BuildException noChildrenAllowed() {
        return new BuildException("You must not specify nested PATH elements when using pathref");
    }

    public class MapEntry {
        private String from = null;
        private String to = null;

        public void setFrom(String from) {
            this.from = from;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String apply(String elem) {
            String cmpFrom;
            if (this.from == null || this.to == null) {
                throw new BuildException("Both 'from' and 'to' must be set in a map entry");
            }
            String cmpElem = PathConvert.this.onWindows ? elem.toLowerCase() : elem;
            String string = cmpFrom = PathConvert.this.onWindows ? this.from.toLowerCase() : this.from;
            if (cmpElem.startsWith(cmpFrom)) {
                int len = this.from.length();
                elem = len >= elem.length() ? this.to : this.to + elem.substring(len);
            }
            return elem;
        }
    }
}

