/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;

public class ChangeLogTask
extends Task
implements ExecuteStreamHandler {
    private File userConfigFile;
    private Properties userList = new Properties();
    private File cvsWorkingDirectory;
    private File outputFile;
    private Date thresholdDate;
    private BufferedReader input;
    private InputStreamReader errorInput;
    private PrintWriter output;
    private Vector filesets = new Vector();
    private String testURL = "http://jakarta.apache.org";
    private PrintWriter debug;
    private static final int GET_ENTRY = 0;
    private static final int GET_FILE = 1;
    private static final int GET_DATE = 2;
    private static final int GET_COMMENT = 3;
    private static final int GET_REVISION = 4;
    private static final SimpleDateFormat INPUT_DATE = new SimpleDateFormat("yyyy/MM/dd");
    private static final SimpleDateFormat FULL_INPUT_DATE = new SimpleDateFormat("yyyy/MM/dd HH:mm");
    private static final SimpleDateFormat OUTPUT_DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat OUTPUT_TIME = new SimpleDateFormat("HH:mm");

    public void setUsers(File theUserConfigFileName) {
        this.userConfigFile = theUserConfigFileName;
    }

    public void setWork(File theWorkDir) {
        this.cvsWorkingDirectory = theWorkDir;
    }

    public void setOutput(File theOutputFile) {
        this.outputFile = theOutputFile;
    }

    public void setDate(String theThresholdDate) {
        try {
            this.thresholdDate = INPUT_DATE.parse(theThresholdDate);
        }
        catch (ParseException e) {
            throw new BuildException("Bad date format [" + theThresholdDate + "].");
        }
    }

    public void setElapsed(Long theElapsedDays) {
        long now = System.currentTimeMillis();
        this.thresholdDate = new Date(now - theElapsedDays * 24L * 60L * 60L * 1000L);
    }

    public void addFileset(FileSet theSet) {
        this.filesets.addElement(theSet);
    }

    public void setTestURL(String theURLString) {
        this.testURL = theURLString;
    }

    public void setDebug(File theDebugFile) throws FileNotFoundException, UnsupportedEncodingException {
        this.debug = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(theDebugFile), "UTF-8"), true);
    }

    private void readUserList() {
        if (this.userConfigFile != null) {
            if (!this.userConfigFile.exists()) {
                throw new BuildException("User list configuration file [" + this.userConfigFile.getAbsolutePath() + "] was not found. Please check location.");
            }
            try {
                this.userList.load(new FileInputStream(this.userConfigFile));
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private boolean testInternetAccess() throws BuildException {
        try {
            URL url = new URL(this.testURL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            connection.disconnect();
        }
        catch (MalformedURLException e) {
            throw new BuildException("Bad URL [" + this.testURL + "]");
        }
        catch (IOException e) {
            if (!this.outputFile.exists()) {
                try {
                    this.output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF-8"));
                    this.output.println("<changelog>");
                    this.output.println("</changelog>");
                    this.output.flush();
                    this.output.close();
                }
                catch (IOException ee) {
                    throw new BuildException((Throwable)ee);
                }
            }
            return false;
        }
        return true;
    }

    public void execute() throws BuildException {
        if (this.cvsWorkingDirectory == null) {
            throw new BuildException("The [workDir] attribute must be set");
        }
        if (!this.cvsWorkingDirectory.exists()) {
            throw new BuildException("Cannot find CVS working directory [" + this.cvsWorkingDirectory.getAbsolutePath() + "]");
        }
        if (this.outputFile == null) {
            throw new BuildException("The [output] attribute must be set");
        }
        this.readUserList();
        if (!this.testInternetAccess()) {
            return;
        }
        Commandline toExecute = new Commandline();
        toExecute.setExecutable("cvs");
        toExecute.createArgument().setValue("log");
        if (this.thresholdDate != null) {
            toExecute.createArgument().setValue("-d\">=" + OUTPUT_DATE.format(this.thresholdDate) + "\"");
        }
        if (!this.filesets.isEmpty()) {
            Enumeration e = this.filesets.elements();
            while (e.hasMoreElements()) {
                FileSet fs = (FileSet)e.nextElement();
                DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
                String[] srcFiles = ds.getIncludedFiles();
                int i = 0;
                while (i < srcFiles.length) {
                    toExecute.createArgument().setValue(srcFiles[i]);
                    ++i;
                }
            }
        }
        Execute exe = new Execute((ExecuteStreamHandler)this);
        exe.setCommandline(toExecute.getCommandline());
        exe.setAntRun(((ProjectComponent)this).project);
        exe.setWorkingDirectory(this.cvsWorkingDirectory);
        try {
            exe.execute();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setProcessInputStream(OutputStream theOs) throws IOException {
    }

    public void setProcessErrorStream(InputStream theIs) throws IOException {
        this.errorInput = new InputStreamReader(theIs);
    }

    public void setProcessOutputStream(InputStream theIs) throws IOException {
        this.input = new BufferedReader(new InputStreamReader(theIs));
    }

    public void stop() {
    }

    public void start() throws IOException {
        this.output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), "UTF-8"));
        String file = null;
        String line = null;
        String date = null;
        String author = null;
        String comment = null;
        String revision = null;
        int status = 1;
        this.debug("State = GET_FILE");
        Hashtable<String, Entry> entries = new Hashtable<String, Entry>();
        while ((line = this.input.readLine()) != null) {
            this.debug("Text: [" + line);
            switch (status) {
                case 1: {
                    if (!line.startsWith("Working file:")) break;
                    file = line.substring(14, line.length());
                    status = 4;
                    this.debug("Next state = GET_REVISION");
                    break;
                }
                case 4: {
                    if (line.startsWith("revision")) {
                        revision = line.substring(9);
                        status = 2;
                        this.debug("Next state = GET_DATE");
                        break;
                    }
                    if (!line.startsWith("======")) break;
                    status = 1;
                    this.debug("Next state = GET_FILE");
                    break;
                }
                case 2: {
                    if (!line.startsWith("date:")) break;
                    date = line.substring(6, 22);
                    line = line.substring(line.indexOf(";") + 1);
                    author = line.substring(10, line.indexOf(";"));
                    if (this.userList != null && ((Hashtable)this.userList).containsKey(author)) {
                        author = "<![CDATA[" + this.userList.getProperty(author) + "]]>";
                    }
                    status = 3;
                    this.debug("Next state = GET_COMMENT");
                    break;
                }
                case 3: {
                    Entry entry;
                    comment = "";
                    while (line != null && !line.startsWith("======") && !line.startsWith("------")) {
                        comment = comment + line + "\n";
                        line = this.input.readLine();
                        this.debug("Text: [" + line);
                    }
                    comment = "<![CDATA[" + comment.substring(0, comment.length() - 1) + "]]>";
                    if (!entries.containsKey(date + author + comment)) {
                        entry = new Entry(date, author, comment);
                        entries.put(date + author + comment, entry);
                    } else {
                        entry = (Entry)entries.get(date + author + comment);
                    }
                    entry.addFile(file, revision);
                    if (line.startsWith("======")) {
                        status = 1;
                        this.debug("Next state = GET_FILE");
                        break;
                    }
                    status = 4;
                    this.debug("Next state = GET_REVISION");
                }
            }
            while (this.errorInput.ready()) {
                this.errorInput.read();
            }
        }
        this.debug("Preparing to write changelog file");
        this.output.println("<changelog>");
        Enumeration en = entries.elements();
        while (en.hasMoreElements()) {
            ((Entry)en.nextElement()).print();
        }
        this.output.println("</changelog>");
        this.output.flush();
        this.output.close();
    }

    private void debug(String theMessage) {
        if (this.debug != null) {
            this.debug.println(theMessage);
        }
    }

    private class Entry {
        private Date date;
        private final String author;
        private final String comment;
        private final Vector files = new Vector();

        public Entry(String theDate, String theAuthor, String theComment) {
            try {
                this.date = FULL_INPUT_DATE.parse(theDate);
            }
            catch (ParseException e) {
                ChangeLogTask.this.log("Bad date format [" + theDate + "].");
            }
            this.author = theAuthor;
            this.comment = theComment;
        }

        public void addFile(String theFile, String theRevision) {
            this.files.addElement(new RCSFile(theFile, theRevision));
        }

        public String toString() {
            return this.author + "\n" + this.date + "\n" + this.files + "\n" + this.comment;
        }

        public void print() {
            ChangeLogTask.this.output.println("\t<entry>");
            ChangeLogTask.this.output.println("\t\t<date>" + OUTPUT_DATE.format(this.date) + "</date>");
            ChangeLogTask.this.output.println("\t\t<time>" + OUTPUT_TIME.format(this.date) + "</time>");
            ChangeLogTask.this.output.println("\t\t<author>" + this.author + "</author>");
            Enumeration e = this.files.elements();
            while (e.hasMoreElements()) {
                RCSFile file = (RCSFile)e.nextElement();
                ChangeLogTask.this.output.println("\t\t<file>");
                ChangeLogTask.this.output.println("\t\t\t<name>" + file.getName() + "</name>");
                ChangeLogTask.this.output.println("\t\t\t<revision>" + file.getRevision() + "</revision>");
                ChangeLogTask.this.output.println("\t\t</file>");
            }
            ChangeLogTask.this.output.println("\t\t<msg>" + this.comment + "</msg>");
            ChangeLogTask.this.output.println("\t</entry>");
        }

        private class RCSFile {
            private String name;
            private String revision;

            private RCSFile(String theName, String theRevision) {
                this.name = theName;
                this.revision = theRevision;
            }

            public String getName() {
                return this.name;
            }

            public String getRevision() {
                return this.revision;
            }
        }
    }
}

