/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.util.log;

import java.net.URL;
import java.util.Hashtable;
import org.apache.cactus.util.log.BaseLog;
import org.apache.cactus.util.log.BaseLogDummy;
import org.apache.cactus.util.log.Log;
import org.apache.log4j.PropertyConfigurator;

public class LogService {
    private Hashtable logCategories = new Hashtable();
    private boolean isInitialized = false;
    private boolean isLog4jInClasspath = true;
    private static LogService instance;

    private LogService() {
        try {
            Class<?> aClass = Class.forName("org.apache.log4j.PropertyConfigurator");
        }
        catch (ClassNotFoundException e) {
            this.isLog4jInClasspath = false;
        }
    }

    public static synchronized LogService getInstance() {
        if (instance == null) {
            instance = new LogService();
        }
        return instance;
    }

    public void init(String theFileName) {
        if (this.isInitialized()) {
            return;
        }
        if (theFileName != null && this.isLog4jInClasspath) {
            URL url = this.getClass().getResource(theFileName);
            if (url != null) {
                PropertyConfigurator.configure((URL)url);
            } else {
                System.err.println("[warning] Failed to configure logging system : Could not find file [" + theFileName + "]");
            }
        }
        this.isInitialized = true;
    }

    public synchronized Log getLog(String theCategoryName) {
        if (!this.isInitialized()) {
            throw new RuntimeException("Must call init() first");
        }
        Log log = (Log)this.logCategories.get(theCategoryName);
        if (log == null) {
            log = this.isLog4jInClasspath ? new BaseLog(theCategoryName) : new BaseLogDummy(theCategoryName);
            this.logCategories.put(theCategoryName, log);
        }
        return log;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }
}

