/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.cactus.Cookie;
import org.apache.cactus.ServletURL;

public class WebRequest {
    private Hashtable parameters = new Hashtable();
    public static final String GET_METHOD = "GET";
    public static final String POST_METHOD = "POST";
    private Vector cookies = new Vector();
    private Hashtable headers = new Hashtable();
    private ServletURL url;
    private boolean isAutomaticSession = true;
    private String method = "POST";

    public void setMethod(String theMethod) {
        if (theMethod.equalsIgnoreCase(GET_METHOD)) {
            this.method = GET_METHOD;
        } else if (theMethod.equalsIgnoreCase(POST_METHOD)) {
            this.method = POST_METHOD;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public void setAutomaticSession(boolean isAutomaticSession) {
        this.isAutomaticSession = isAutomaticSession;
    }

    public boolean getAutomaticSession() {
        return this.isAutomaticSession;
    }

    public void setURL(String theServerName, String theContextPath, String theServletPath, String thePathInfo, String theQueryString) {
        this.url = new ServletURL(theServerName, theContextPath, theServletPath, thePathInfo, theQueryString);
        this.addQueryStringParameters(theQueryString);
    }

    public ServletURL getURL() {
        return this.url;
    }

    public void addParameter(String theName, String theValue) {
        if (this.parameters.containsKey(theName)) {
            Vector v = (Vector)this.parameters.get(theName);
            v.addElement(theValue);
        } else {
            Vector<String> v = new Vector<String>();
            v.addElement(theValue);
            this.parameters.put(theName, v);
        }
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public String getParameter(String theName) {
        String[] values = this.getParameterValues(theName);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public String[] getParameterValues(String theName) {
        if (this.parameters.containsKey(theName)) {
            Vector v = (Vector)this.parameters.get(theName);
            Object[] objs = new Object[v.size()];
            v.copyInto(objs);
            String[] result = new String[objs.length];
            int i = 0;
            while (i < objs.length) {
                result[i] = (String)objs[i];
                ++i;
            }
            return result;
        }
        return null;
    }

    public void addCookie(String theName, String theValue) {
        this.addCookie("localhost", theName, theValue);
    }

    public void addCookie(String theDomain, String theName, String theValue) {
        this.addCookie(new Cookie(theDomain, theName, theValue));
    }

    public void addCookie(Cookie theCookie) {
        this.cookies.addElement(theCookie);
    }

    public Vector getCookies() {
        return this.cookies;
    }

    public void addHeader(String theName, String theValue) {
        if (this.headers.containsKey(theName)) {
            Vector v = (Vector)this.headers.get(theName);
            v.addElement(theValue);
        } else {
            Vector<String> v = new Vector<String>();
            v.addElement(theValue);
            this.headers.put(theName, v);
        }
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public String getHeader(String theName) {
        String[] values = this.getHeaderValues(theName);
        if (values != null) {
            return values[0];
        }
        return null;
    }

    public String[] getHeaderValues(String theName) {
        if (this.headers.containsKey(theName)) {
            Vector v = (Vector)this.headers.get(theName);
            Object[] objs = new Object[v.size()];
            v.copyInto(objs);
            String[] result = new String[objs.length];
            int i = 0;
            while (i < objs.length) {
                result[i] = (String)objs[i];
                ++i;
            }
            return result;
        }
        return null;
    }

    private void addQueryStringParameters(String theQueryString) {
        if (theQueryString == null) {
            return;
        }
        String nameValue = null;
        StringTokenizer tokenizer = new StringTokenizer(theQueryString, "&");
        int breakParam = -1;
        while (tokenizer.hasMoreTokens()) {
            nameValue = tokenizer.nextToken();
            breakParam = nameValue.indexOf("=");
            if (breakParam != -1) {
                this.addParameter(nameValue.substring(0, breakParam), nameValue.substring(breakParam + 1));
                continue;
            }
            throw new RuntimeException("Bad QueryString [" + theQueryString + "] NameValue pair: [" + nameValue + "]");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("simulation URL = [" + this.getURL() + "], ");
        buffer.append("automatic session = [" + this.getAutomaticSession() + "], ");
        buffer.append("cookies = [");
        Enumeration cookies = this.getCookies().elements();
        while (cookies.hasMoreElements()) {
            Cookie cookie = (Cookie)cookies.nextElement();
            buffer.append("[" + cookie + "]");
        }
        buffer.append("], ");
        buffer.append("headers = [");
        Enumeration headers = this.getHeaderNames();
        while (headers.hasMoreElements()) {
            buffer.append("[");
            String headerName = (String)headers.nextElement();
            String[] headerValues = this.getHeaderValues(headerName);
            buffer.append("[" + headerName + "] = [");
            int i = 0;
            while (i < headerValues.length - 1) {
                buffer.append("[" + headerValues[i] + "], ");
                ++i;
            }
            buffer.append("[" + headerValues[headerValues.length - 1] + "]]");
            buffer.append("]");
        }
        buffer.append("], ");
        buffer.append("method = [" + this.getMethod() + "], ");
        buffer.append("parameters = [");
        Enumeration parameters = this.getParameterNames();
        while (parameters.hasMoreElements()) {
            buffer.append("[");
            String parameterName = (String)parameters.nextElement();
            String[] parameterValues = this.getParameterValues(parameterName);
            buffer.append("[" + parameterName + "] = [");
            int i = 0;
            while (i < parameterValues.length - 1) {
                buffer.append("[" + parameterValues[i] + "], ");
                ++i;
            }
            buffer.append("[" + parameterValues[parameterValues.length - 1] + "]]");
            buffer.append("]");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

