/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.DataSetException;
import com.workingdogs.village.KeyDef;
import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import com.workingdogs.village.Schema;
import com.workingdogs.village.TableDataSet;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public abstract class DataSet {
    protected static final int ALL_RECORDS = -1;
    Schema schema;
    Vector records = null;
    Connection conn;
    boolean allRecordsRetrieved = false;
    int recordRetrievedCount = 0;
    int lastFetchSize = 0;
    int totalFetchCount = 0;
    private String columns;
    StringBuffer selectString;
    private KeyDef keyDefValue;
    ResultSet resultSet;
    Statement stmt;

    public DataSet() throws DataSetException, SQLException {
    }

    DataSet(Connection connection, String string) throws DataSetException, SQLException {
        this.conn = connection;
        this.columns = "*";
        this.schema = new Schema().schema(connection, string);
    }

    DataSet(Connection connection, Schema schema, KeyDef keyDef) throws DataSetException, SQLException {
        if (connection == null) {
            throw new SQLException("Database connection could not be established!");
        }
        if (schema == null) {
            throw new DataSetException("You need to specify a valid schema!");
        }
        if (keyDef == null) {
            throw new DataSetException("You need to specify a valid KeyDef!");
        }
        this.conn = connection;
        this.schema = schema;
        this.columns = "*";
        this.keyDefValue = keyDef;
    }

    DataSet(Connection connection, String string, KeyDef keyDef) throws SQLException, DataSetException {
        this.conn = connection;
        this.keyDefValue = keyDef;
        this.columns = "*";
        this.schema = new Schema().schema(connection, string);
    }

    DataSet(Connection connection, String string, String string2) throws SQLException, DataSetException {
        this.conn = connection;
        this.columns = string2;
        this.schema = new Schema().schema(connection, string, string2);
    }

    DataSet(Connection connection, String string, String string2, KeyDef keyDef) throws SQLException, DataSetException {
        this.conn = connection;
        this.columns = string2;
        this.keyDefValue = keyDef;
        this.schema = new Schema().schema(connection, string, string2);
    }

    public ResultSet resultSet() throws SQLException, DataSetException {
        if (this.resultSet == null) {
            throw new DataSetException("ResultSet is null.");
        }
        return this.resultSet;
    }

    public Record addRecord() throws DataSetException, SQLException {
        return this.addRecord(this);
    }

    public Record addRecord(DataSet dataSet) throws DataSetException, SQLException {
        if (dataSet instanceof QueryDataSet) {
            throw new DataSetException("You cannot add records to a QueryDataSet.");
        }
        if (this.records == null) {
            this.records = new Vector(10);
        }
        Record record = new Record(dataSet, true);
        record.markForInsert();
        this.records.addElement(record);
        return record;
    }

    public boolean allRecordsRetrieved() {
        return this.allRecordsRetrieved;
    }

    void setAllRecordsRetrieved(boolean bl) {
        this.allRecordsRetrieved = bl;
    }

    public Record removeRecord(Record record) throws DataSetException {
        Record record2 = null;
        try {
            int n = this.records.indexOf(record);
            record2 = (Record)this.records.elementAt(n);
            this.records.removeElementAt(n);
        }
        catch (Exception exception) {
            throw new DataSetException("Record could not be removed!");
        }
        return record2;
    }

    public DataSet clearRecords() {
        this.records.removeAllElements();
        this.records = null;
        return this;
    }

    public DataSet releaseRecords() {
        this.records = null;
        this.recordRetrievedCount = 0;
        this.lastFetchSize = 0;
        this.setAllRecordsRetrieved(false);
        return this;
    }

    public void close() throws SQLException, DataSetException {
        this.releaseRecords();
        this.schema = null;
        if (this.resultSet != null && !(this instanceof QueryDataSet)) {
            this.resultSet().close();
        }
        this.resultSet = null;
        if (this.stmt != null) {
            this.stmt.close();
        }
        this.conn = null;
    }

    public DataSet reset() throws DataSetException, SQLException {
        if (this.resultSet() == null || !(this instanceof QueryDataSet)) {
            return this.releaseRecords();
        }
        throw new DataSetException("You cannot call reset() on a QueryDataSet.");
    }

    public Connection connection() throws SQLException {
        return this.conn;
    }

    public Schema schema() {
        return this.schema;
    }

    public Record getRecord(int n) throws DataSetException {
        if (this.containsRecord(n)) {
            Record record = (Record)this.records.elementAt(n);
            if (this instanceof TableDataSet) {
                record.markForUpdate();
            }
            ++this.recordRetrievedCount;
            return record;
        }
        throw new DataSetException("Record not found at index: " + n);
    }

    Record findRecord(int n) throws DataSetException {
        if (this.containsRecord(n)) {
            return (Record)this.records.elementAt(n);
        }
        throw new DataSetException("Record not found at index: " + n);
    }

    public boolean containsRecord(int n) {
        try {
            if (this.records.elementAt(n) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public DataSet fetchRecords() throws SQLException, DataSetException {
        return this.fetchRecords(-1);
    }

    public DataSet fetchRecords(int n) throws SQLException, DataSetException {
        return this.fetchRecords(0, n);
    }

    public DataSet fetchRecords(int n, int n2) throws SQLException, DataSetException {
        if (n2 == 0) {
            throw new DataSetException("Max is 1 based and must be greater than 0!");
        }
        if (this.lastFetchSize() > 0 && this.records != null) {
            throw new DataSetException("You must call DataSet.clearRecords() before executing DataSet.fetchRecords() again!");
        }
        if (this.selectString == null) {
            this.selectString = new StringBuffer(256);
            this.selectString.append("SELECT ");
            this.selectString.append(this.schema().attributes());
            this.selectString.append(" FROM ");
            this.selectString.append(this.schema().tableName());
        }
        try {
            if (this.stmt == null && this.resultSet == null) {
                this.stmt = this.connection().createStatement();
                this.resultSet = this.stmt.executeQuery(this.selectString.toString());
            }
            if (this.resultSet != null) {
                this.records = this.records == null && n2 > 0 ? new Vector(n2) : new Vector();
                int n3 = 0;
                int n4 = 0;
                while (!this.allRecordsRetrieved()) {
                    if (n4 == n2) break;
                    if (this.resultSet.next()) {
                        if (n3 >= n) {
                            Record record = new Record(this);
                            this.records.addElement(record);
                            ++n4;
                            continue;
                        }
                        ++n3;
                        continue;
                    }
                    this.setAllRecordsRetrieved(true);
                    break;
                }
                this.lastFetchSize = n4;
            }
        }
        catch (SQLException sQLException) {
            if (this.stmt != null) {
                this.stmt.close();
            }
            throw new SQLException(sQLException.getMessage());
        }
        return this;
    }

    public int lastFetchSize() {
        return this.lastFetchSize;
    }

    public KeyDef keydef() {
        return this.keyDefValue;
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            if (this.schema != null) {
                printWriter.println(this.schema.toString());
            }
            int n = 0;
            while (n < this.size()) {
                printWriter.println(this.findRecord(n));
                ++n;
            }
            printWriter.flush();
            return byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            return "{}";
        }
    }

    public String tableName() throws DataSetException {
        return this.schema().tableName();
    }

    public int[] maxColumnWidths(boolean bl) throws DataSetException, SQLException {
        if (this.schema() == null) {
            throw new DataSetException("Schema is null!");
        }
        throw new DataSetException("Not yet implemented!");
    }

    public abstract String getSelectString() throws DataSetException;

    String getColumns() {
        return this.columns;
    }

    public int size() {
        if (this.records == null) {
            return 0;
        }
        return this.records.size();
    }
}

