/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.server;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.apache.cactus.server.ServletContextWrapper;

public class FilterConfigWrapper
implements FilterConfig {
    private FilterConfig originalConfig;
    private Hashtable initParameters;
    private String filterName;

    public FilterConfigWrapper(FilterConfig theOriginalConfig) {
        this.originalConfig = theOriginalConfig;
        this.initParameters = new Hashtable();
    }

    public void setInitParameter(String theName, String theValue) {
        this.initParameters.put(theName, theValue);
    }

    public void setFilterName(String theFilterName) {
        this.filterName = theFilterName;
    }

    public String getFilterName() {
        if (this.filterName != null) {
            return this.filterName;
        }
        return this.originalConfig.getFilterName();
    }

    public ServletContext getServletContext() {
        return new ServletContextWrapper(this.originalConfig.getServletContext());
    }

    public Enumeration getInitParameterNames() {
        String value;
        Vector<String> names = new Vector<String>();
        Enumeration enumeration = this.initParameters.keys();
        while (enumeration.hasMoreElements()) {
            value = (String)enumeration.nextElement();
            names.add(value);
        }
        enumeration = this.originalConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            value = (String)enumeration.nextElement();
            if (names.contains(value)) continue;
            names.add(value);
        }
        return names.elements();
    }

    public String getInitParameter(String theName) {
        String value = (String)this.initParameters.get(theName);
        if (value == null) {
            value = this.originalConfig.getInitParameter(theName);
        }
        return value;
    }
}

