/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.log;

import org.apache.commons.httpclient.log.Log;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class Log4JCategoryLog
implements Log {
    Category _category = null;

    public Log4JCategoryLog(String name) {
        this._category = Category.getInstance((String)name);
    }

    public final void debug(Object message) {
        this._category.debug(message);
    }

    public final void debug(Object message, Throwable t) {
        this._category.debug(message, t);
    }

    public final void info(Object message) {
        this._category.info(message);
    }

    public final void info(Object message, Throwable t) {
        this._category.info(message, t);
    }

    public final void warn(Object message) {
        this._category.warn(message);
    }

    public final void warn(Object message, Throwable t) {
        this._category.warn(message, t);
    }

    public final void error(Object message) {
        this._category.error(message);
    }

    public final void error(Object message, Throwable t) {
        this._category.error(message, t);
    }

    public final void fatal(Object message) {
        this._category.fatal(message);
    }

    public final void fatal(Object message, Throwable t) {
        this._category.fatal(message, t);
    }

    public final boolean isDebugEnabled() {
        return this._category.isDebugEnabled();
    }

    public final boolean isInfoEnabled() {
        return this._category.isInfoEnabled();
    }

    public final boolean isEnabledFor(Priority p) {
        return this._category.isEnabledFor(p);
    }

    public final void setLevel(int level) {
        switch (level) {
            case 10000: {
                this._category.setPriority(Priority.DEBUG);
                break;
            }
            case 20000: {
                this._category.setPriority(Priority.INFO);
                break;
            }
            case 30000: {
                this._category.setPriority(Priority.WARN);
                break;
            }
            case 40000: {
                this._category.setPriority(Priority.ERROR);
                break;
            }
            case 50000: {
                this._category.setPriority(Priority.FATAL);
                break;
            }
            default: {
                this._category.setPriority(Priority.toPriority((int)level));
            }
        }
    }

    public final int getLevel() {
        return this._category.getPriority().toInt();
    }
}

